/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.UpdateResult;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.UpdateResultInternal;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.query.namedparameter.SqlAndParamsForNamed;
import org.codejargon.fluentjdbc.internal.support.Ints;
import org.codejargon.fluentjdbc.internal.support.Iterables;
import org.codejargon.fluentjdbc.internal.support.Preconditions;
import org.codejargon.fluentjdbc.internal.support.Sneaky;

class BatchQueryInternal
implements BatchQuery {
    private final String sql;
    private final QueryInternal query;
    private Optional<Iterator<List<Object>>> params = Optional.empty();
    private Optional<Iterator<Map<String, Object>>> namedParams = Optional.empty();
    private Optional<Integer> batchSize = Optional.empty();

    public BatchQueryInternal(String sql, QueryInternal query) {
        this.sql = sql;
        this.query = query;
    }

    @Override
    public BatchQuery params(Iterator<List<Object>> params) {
        Preconditions.checkNotNull(params, "params");
        Preconditions.checkArgument(!this.namedParams.isPresent(), "Positional parameters can't be set if named parameters are already set.");
        this.params = Optional.of(params);
        return this;
    }

    @Override
    public BatchQuery namedParams(Iterator<Map<String, Object>> namedParams) {
        Preconditions.checkNotNull(namedParams, "namedParams");
        Preconditions.checkArgument(!this.params.isPresent(), "Named parameters can't be set if positional parameters are already set.");
        this.namedParams = Optional.of(namedParams);
        return this;
    }

    @Override
    public BatchQuery batchSize(Integer batchSize) {
        Preconditions.checkNotNull(batchSize, "batch size");
        Preconditions.checkArgument(batchSize > 0, "batch size must be greater than 0");
        this.batchSize = Optional.of(batchSize);
        return this;
    }

    @Override
    public List<UpdateResult> run() {
        Preconditions.checkArgument(this.params.isPresent() || this.namedParams.isPresent(), "Parameters must be set to run a batch query");
        return this.query.query(connection -> this.params.isPresent() ? this.positional(connection) : this.named(connection), this.sql);
    }

    private List<UpdateResult> positional(Connection connection) throws SQLException {
        try (PreparedStatement statement = this.query.preparedStatementFactory.createBatch(connection, this.sql);){
            List<UpdateResult> list = this.runBatches(statement, Iterables.stream(this.params.get()));
            return list;
        }
    }

    private List<UpdateResult> named(Connection connection) throws SQLException {
        NamedTransformedSql namedTransformedSql = this.query.config.namedTransformedSql(this.sql);
        try (PreparedStatement statement = this.query.preparedStatementFactory.createBatch(connection, namedTransformedSql.sql());){
            List<UpdateResult> list = this.runBatches(statement, Iterables.stream(this.namedParams.get()).map(namedParam -> SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), namedParam)));
            return list;
        }
    }

    private List<UpdateResult> runBatches(PreparedStatement ps, Stream<List<Object>> params) throws SQLException {
        BatchExecution batchExecution = new BatchExecution(ps);
        params.forEachOrdered(Sneaky.consumer(batchExecution::add));
        return batchExecution.results();
    }

    private class BatchExecution {
        private final PreparedStatement ps;
        private final List<UpdateResult> updateResults = new ArrayList<UpdateResult>();
        private long totalBatchesAdded = 0L;
        private boolean newAdded = false;

        public BatchExecution(PreparedStatement ps) {
            this.ps = ps;
        }

        public void add(List<Object> params) throws SQLException {
            this.addParamsToBatch(params);
            if (BatchQueryInternal.this.batchSize.isPresent() && this.totalBatchesAdded % (long)((Integer)BatchQueryInternal.this.batchSize.get()).intValue() == 0L) {
                this.runBatch();
            }
        }

        private void addParamsToBatch(List<Object> params) throws SQLException {
            BatchQueryInternal.this.query.assignParams(this.ps, params);
            this.ps.addBatch();
            ++this.totalBatchesAdded;
            this.newAdded = true;
        }

        private void runBatch() throws SQLException {
            this.updateResults.addAll(Ints.asList(this.ps.executeBatch()).stream().map(i -> (long)i).map(UpdateResultInternal::new).collect(Collectors.toList()));
            this.newAdded = false;
        }

        private List<UpdateResult> results() throws SQLException {
            if (this.newAdded) {
                this.runBatch();
            }
            return Collections.unmodifiableList(this.updateResults);
        }
    }
}

