/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query.namedparameter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedParameterUtils;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.query.namedparameter.ParsedSql;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public abstract class SqlAndParamsForNamed {
    public static SqlAndParams create(NamedTransformedSql namedTransformedSql, Map<String, Object> namedParams) {
        Preconditions.checkArgument(namedTransformedSql.unnamedParameterCount() == 0, String.format("Querying with named parameters cannot be run with SQL statements containing positional parameters: %s", namedTransformedSql.sql()));
        return new SqlAndParams(namedTransformedSql.sql(), SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), namedParams));
    }

    private static List<Object> params(ParsedSql parsedSql, Map<String, Object> namedParams) {
        return Arrays.asList(NamedParameterUtils.buildValueArray(parsedSql, namedParams));
    }
}

