/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.ParamSetter;

public class DefaultParamSetters {
    private static final Map<Class, ParamSetter> setters;

    private static void javaTime(Map<Class, ParamSetter> ss) {
        DefaultParamSetters.reg(ss, Instant.class, (param, ps, i) -> ps.setTimestamp(i, DefaultParamSetters.timestamp(param)));
        DefaultParamSetters.reg(ss, OffsetDateTime.class, (param, ps, i) -> ps.setTimestamp(i, DefaultParamSetters.timestamp(param.toInstant())));
        DefaultParamSetters.reg(ss, ZonedDateTime.class, (param, ps, i) -> ps.setTimestamp(i, DefaultParamSetters.timestamp(param.toInstant())));
        DefaultParamSetters.reg(ss, LocalDate.class, (param, ps, i) -> ps.setDate(i, java.sql.Date.valueOf(param)));
        DefaultParamSetters.reg(ss, LocalTime.class, (param, ps, i) -> ps.setTime(i, Time.valueOf(param)));
        DefaultParamSetters.reg(ss, LocalDateTime.class, (param, ps, i) -> ps.setTimestamp(i, Timestamp.valueOf(param)));
        DefaultParamSetters.reg(ss, Year.class, (param, ps, i) -> ps.setDate(i, java.sql.Date.valueOf(LocalDate.of(param.getValue(), Month.JANUARY, 1))));
        DefaultParamSetters.reg(ss, YearMonth.class, (param, ps, i) -> ps.setDate(i, java.sql.Date.valueOf(LocalDate.of(param.getYear(), param.getMonth(), 1))));
    }

    private static void javaDate(Map<Class, ParamSetter> ss) {
        DefaultParamSetters.reg(ss, Date.class, (param, ps, i) -> ps.setDate(i, new java.sql.Date(param.getTime())));
    }

    public static Map<Class, ParamSetter> setters() {
        return setters;
    }

    static Timestamp timestamp(Instant instant) {
        return Timestamp.from(instant);
    }

    private static <T> void reg(Map<Class, ParamSetter> setters, Class<T> clazz, ParamSetter<T> setter) {
        setters.put(clazz, setter);
    }

    static {
        HashMap<Class, ParamSetter> ss = new HashMap<Class, ParamSetter>();
        DefaultParamSetters.javaDate(ss);
        DefaultParamSetters.javaTime(ss);
        setters = Collections.unmodifiableMap(ss);
    }
}

