/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.standalone;

import com.google.inject.persist.Transactional;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.codejargon.fluentjdbc.api.integration.guicepersist.standalone.StandaloneTxConnectionProvider;
import org.codejargon.fluentjdbc.internal.support.Lists;

class TransactionInterceptor
implements MethodInterceptor {
    private final StandaloneTxConnectionProvider standaloneTxConnectionProvider;

    TransactionInterceptor(StandaloneTxConnectionProvider standaloneTxConnectionProvider) {
        this.standaloneTxConnectionProvider = standaloneTxConnectionProvider;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Boolean bl = this.startNewTransactionIfNecessary();
        try {
            Object object = this.invokeMethodAndCommitIfNecessary(methodInvocation, bl);
            return object;
        }
        catch (Exception exception) {
            this.rollbackOrCommit(methodInvocation, exception);
            throw exception;
        }
        finally {
            if (bl.booleanValue()) {
                this.standaloneTxConnectionProvider.removeActiveTransactionConnection();
            }
        }
    }

    private Object invokeMethodAndCommitIfNecessary(MethodInvocation methodInvocation, Boolean bl) throws Throwable {
        Object object = methodInvocation.proceed();
        if (bl.booleanValue()) {
            this.standaloneTxConnectionProvider.commitActiveTransaction();
        }
        return object;
    }

    private Boolean startNewTransactionIfNecessary() {
        Boolean bl;
        if (!this.standaloneTxConnectionProvider.hasActiveTransaction().booleanValue()) {
            this.standaloneTxConnectionProvider.startNewTransaction();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void rollbackOrCommit(MethodInvocation methodInvocation, Exception exception) {
        if (this.rollbackNecessary(exception, this.transactional(methodInvocation))) {
            this.standaloneTxConnectionProvider.rollbackActiveTransaction();
        } else {
            this.standaloneTxConnectionProvider.commitActiveTransaction();
        }
    }

    private Transactional transactional(MethodInvocation methodInvocation) {
        return TransactionInterceptor.suppliers(() -> methodInvocation.getMethod().getAnnotation(Transactional.class), () -> methodInvocation.getThis().getClass().getAnnotation(Transactional.class), this::defaultTransactional).stream().map(Supplier::get).filter(transactional -> transactional != null).findFirst().get();
    }

    @SafeVarargs
    private static <T> List<Supplier<T>> suppliers(Supplier<T> ... supplierArray) {
        return Arrays.asList(supplierArray);
    }

    private boolean rollbackNecessary(Exception exception, Transactional transactional) {
        return this.has(transactional.rollbackOn(), exception) != false && this.has(transactional.ignore(), exception) == false;
    }

    private Boolean has(Class<? extends Exception>[] classArray, Exception exception) {
        return Lists.copyOf((Object[])classArray).stream().filter(clazz -> clazz.isInstance(exception)).findAny().isPresent();
    }

    private Transactional defaultTransactional() {
        return DefaultTransactionalDummy.class.getAnnotation(Transactional.class);
    }

    @Transactional
    private static class DefaultTransactionalDummy {
        private DefaultTransactionalDummy() {
        }
    }
}

