package org.xdoclet.plugin.hibernate.qtags;

public class HibernatePropertyTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernatePropertyTag {
    public static final String NAME = "hibernate.property";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"optimistic-lock",
		"lazy",
		"insert",
		"formula",
		"unique",
		"join-name",
		"type",
		"update",
		"generated",
		"column",
		"name",
		"properties-name",
		"index",
		"not-null",
		"node",
		"length",
		"precision",
		"access",
		"scale",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernatePropertyTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernatePropertyTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.Boolean getOptimisticLock() {
		boolean required = false;
        String result = getNamedParameter("optimistic-lock");
        if(required && result == null) {
            bomb("optimistic-lock=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getLazy() {
		boolean required = false;
        String result = getNamedParameter("lazy");
        if(required && result == null) {
            bomb("lazy=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("true")|| result.equals("false")|| result.equals("proxy")|| result.equals("no-proxy")|| result.equals("extra")) ) {
	                // todo we should say what file and line number too
	                bomb("lazy=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getInsert() {
		boolean required = false;
        String result = getNamedParameter("insert");
        if(required && result == null) {
            bomb("insert=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getFormula() {
		boolean required = false;
        String result = getNamedParameter("formula");
        if(required && result == null) {
            bomb("formula=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getUnique() {
		boolean required = false;
        String result = getNamedParameter("unique");
        if(required && result == null) {
            bomb("unique=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getJoinName() {
		boolean required = false;
        String result = getNamedParameter("join-name");
        if(required && result == null) {
            bomb("join-name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getType() {
		boolean required = false;
        String result = getNamedParameter("type");
        if(required && result == null) {
            bomb("type=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getUpdate() {
		boolean required = false;
        String result = getNamedParameter("update");
        if(required && result == null) {
            bomb("update=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getGenerated() {
		boolean required = false;
        String result = getNamedParameter("generated");
        if(required && result == null) {
            bomb("generated=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("newer")|| result.equals("always")|| result.equals("true")|| result.equals("false")) ) {
	                // todo we should say what file and line number too
	                bomb("generated=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getColumn() {
		boolean required = false;
        String result = getNamedParameter("column");
        if(required && result == null) {
            bomb("column=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getName_() {
		boolean required = false;
        String result = getNamedParameter("name");
        if(required && result == null) {
            bomb("name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getPropertiesName() {
		boolean required = false;
        String result = getNamedParameter("properties-name");
        if(required && result == null) {
            bomb("properties-name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getIndex() {
		boolean required = false;
        String result = getNamedParameter("index");
        if(required && result == null) {
            bomb("index=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getNotNull() {
		boolean required = false;
        String result = getNamedParameter("not-null");
        if(required && result == null) {
            bomb("not-null=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getNode() {
		boolean required = false;
        String result = getNamedParameter("node");
        if(required && result == null) {
            bomb("node=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Integer getLength() {
		boolean required = false;
        String result = getNamedParameter("length");
        if(required && result == null) {
            bomb("length=\"???\" must be specified.");
        }

		java.lang.Integer retVal = null;


		if (result != null) {
	            try {
	                retVal = Integer.decode(result);
	            } catch(NumberFormatException nfe) {
	                bomb("length=\"" + result + "\" is not valid integer");
	                throw nfe;
	            }
		}
		
		return retVal;
    }
    public java.lang.String getPrecision() {
		boolean required = false;
        String result = getNamedParameter("precision");
        if(required && result == null) {
            bomb("precision=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getAccess() {
		boolean required = false;
        String result = getNamedParameter("access");
        if(required && result == null) {
            bomb("access=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getScale() {
		boolean required = false;
        String result = getNamedParameter("scale");
        if(required && result == null) {
            bomb("scale=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
		if(isOnClass) {
        	bomb("is not allowed on classes");
		}
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
        
        // check uniqueness
        // deprecated here. check validateModel
		if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
			bomb("is allowed only once");
		}

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getOptimisticLock();
        getLazy();
        getInsert();
        getFormula();
        getUnique();
        getJoinName();
        getType();
        getUpdate();
        getGenerated();
        getColumn();
        getName_();
        getPropertiesName();
        getIndex();
        getNotNull();
        getNode();
        getLength();
        getPrecision();
        getAccess();
        getScale();
    }

    public void validateModel() {
        // check uniqueness
        if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
            bomb("is allowed only once");
        }
    }
}