package org.xdoclet.plugin.hibernate.qtags;

public class HibernateIdTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernateIdTag {
    public static final String NAME = "hibernate.id";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"generator-class",
		"name",
		"unsaved-value",
		"node",
		"type",
		"length",
		"access",
		"column",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernateIdTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernateIdTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.String getGeneratorClass() {
		boolean required = true;
        String result = getNamedParameter("generator-class");
        if(required && result == null) {
            bomb("generator-class=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getName_() {
		boolean required = false;
        String result = getNamedParameter("name");
        if(required && result == null) {
            bomb("name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getUnsavedValue() {
		boolean required = false;
        String result = getNamedParameter("unsaved-value");
        if(required && result == null) {
            bomb("unsaved-value=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getNode() {
		boolean required = false;
        String result = getNamedParameter("node");
        if(required && result == null) {
            bomb("node=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getType() {
		boolean required = false;
        String result = getNamedParameter("type");
        if(required && result == null) {
            bomb("type=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Integer getLength() {
		boolean required = false;
        String result = getNamedParameter("length");
        if(required && result == null) {
            bomb("length=\"???\" must be specified.");
        }

		java.lang.Integer retVal = null;


		if (result != null) {
	            try {
	                retVal = Integer.decode(result);
	            } catch(NumberFormatException nfe) {
	                bomb("length=\"" + result + "\" is not valid integer");
	                throw nfe;
	            }
		}
		
		return retVal;
    }
    public java.lang.String getAccess() {
		boolean required = false;
        String result = getNamedParameter("access");
        if(required && result == null) {
            bomb("access=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getColumn() {
		boolean required = false;
        String result = getNamedParameter("column");
        if(required && result == null) {
            bomb("column=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
		if(isOnClass) {
        	bomb("is not allowed on classes");
		}
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
        
        // check uniqueness

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getGeneratorClass();
        getName_();
        getUnsavedValue();
        getNode();
        getType();
        getLength();
        getAccess();
        getColumn();
    }

    public void validateModel() {
        // check uniqueness
    }
}