package org.xdoclet.plugin.hibernate.qtags;

public class HibernateDiscriminatorTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernateDiscriminatorTag {
    public static final String NAME = "hibernate.discriminator";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"column",
		"force",
		"formula",
		"insert",
		"not-null",
		"type",
		"length",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernateDiscriminatorTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernateDiscriminatorTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.String getColumn() {
		boolean required = false;
        String result = getNamedParameter("column");
        if(required && result == null) {
            bomb("column=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getForce() {
		boolean required = false;
        String result = getNamedParameter("force");
        if(required && result == null) {
            bomb("force=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getFormula() {
		boolean required = false;
        String result = getNamedParameter("formula");
        if(required && result == null) {
            bomb("formula=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getInsert() {
		boolean required = false;
        String result = getNamedParameter("insert");
        if(required && result == null) {
            bomb("insert=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.Boolean getNotNull() {
		boolean required = false;
        String result = getNamedParameter("not-null");
        if(required && result == null) {
            bomb("not-null=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getType() {
		boolean required = false;
        String result = getNamedParameter("type");
        if(required && result == null) {
            bomb("type=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Integer getLength() {
		boolean required = false;
        String result = getNamedParameter("length");
        if(required && result == null) {
            bomb("length=\"???\" must be specified.");
        }

		java.lang.Integer retVal = null;


		if (result != null) {
	            try {
	                retVal = Integer.decode(result);
	            } catch(NumberFormatException nfe) {
	                bomb("length=\"" + result + "\" is not valid integer");
	                throw nfe;
	            }
		}
		
		return retVal;
    }

    protected void validateLocation() {
        if(isOnField) {
            bomb("is not allowed on fields");
        }
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
		if(isOnMethod) {
        	bomb("is not allowed on methods");
		}
        
        // check uniqueness

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getColumn();
        getForce();
        getFormula();
        getInsert();
        getNotNull();
        getType();
        getLength();
    }

    public void validateModel() {
        // check uniqueness
    }
}