/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.waffle.context.pico;

import javax.servlet.ServletContext;
import org.codehaus.waffle.Startable;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyScriptLoader
implements Startable {
    public static final String DEFAULT_RUBY_SCRIPT_PATH = "/WEB-INF/classes/";
    public static final String RUBY_SCRIPT_PATH_KEY = "org.codehaus.waffle.ruby.path";
    public static final String RUBY_SCRIPT_ENV_KEY = "org.codehaus.waffle.ruby.env";
    private final ServletContext servletContext;
    private final Ruby runtime;
    private final String rubyScriptPath;

    public RubyScriptLoader(ServletContext servletContext, Ruby runtime) {
        this.servletContext = servletContext;
        this.runtime = runtime;
        this.rubyScriptPath = this.getScriptPath(servletContext);
    }

    String getScriptPath(ServletContext servletContext) {
        String path = servletContext.getInitParameter(RUBY_SCRIPT_PATH_KEY);
        if (path == null) {
            String env = this.getScriptEnv(servletContext);
            if (env == null) {
                return DEFAULT_RUBY_SCRIPT_PATH;
            }
            path = env;
        }
        return path;
    }

    private String getScriptEnv(ServletContext servletContext) {
        String name = servletContext.getInitParameter(RUBY_SCRIPT_ENV_KEY);
        if (name == null) {
            return null;
        }
        return System.getenv(name);
    }

    public void start() {
        this.runtime.getClassFromPath("Waffle::ScriptLoader").callMethod(this.runtime.getCurrentContext(), "load_all", new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)this.rubyScriptPath), JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)this.servletContext)});
    }

    public void stop() {
    }
}

