/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.waffle.context.pico;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import org.codehaus.waffle.WaffleException;
import org.codehaus.waffle.context.ContextContainer;
import org.codehaus.waffle.context.pico.RubyScriptLoader;
import org.codehaus.waffle.context.pico.ScriptedPicoContextContainerFactory;
import org.codehaus.waffle.i18n.MessageResources;
import org.codehaus.waffle.monitor.ContextMonitor;
import org.codehaus.waffle.monitor.RegistrarMonitor;
import org.codehaus.waffle.registrar.Registrar;
import org.codehaus.waffle.registrar.pico.ParameterResolver;
import org.codehaus.waffle.registrar.pico.RubyScriptedRegistrar;
import org.jruby.Ruby;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;

public class RubyPicoContextContainerFactory
extends ScriptedPicoContextContainerFactory {
    public RubyPicoContextContainerFactory(MessageResources messageResources, ContextMonitor contextMonitor, RegistrarMonitor registrarMonitor, ParameterResolver parameterResolver) {
        super(messageResources, contextMonitor, registrarMonitor, parameterResolver);
    }

    protected void registerScriptComponents(ContextContainer contextContainer) {
        MutablePicoContainer picoContainer = (MutablePicoContainer)contextContainer.getDelegate();
        Ruby runtime = Ruby.newInstance();
        runtime.getLoadService().init(new ArrayList());
        this.loadRubyScriptFromClassLoader("org/codehaus/waffle/waffle_erb.rb", runtime);
        this.loadRubyScriptFromClassLoader("org/codehaus/waffle/waffle.rb", runtime);
        picoContainer.addComponent(Ruby.class, (Object)runtime, new Parameter[0]);
        picoContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(RubyScriptLoader.class);
    }

    protected Registrar createRegistrar(ContextContainer contextContainer) {
        MutablePicoContainer delegateContainer = (MutablePicoContainer)contextContainer.getDelegate();
        RegistrarMonitor registrarMonitor = this.getRegistrarMonitor();
        RubyScriptedRegistrar registrar = new RubyScriptedRegistrar(delegateContainer, this.getParameterResolver(), this.getPicoLifecycleStrategy(), registrarMonitor, this.getPicoComponentMonitor());
        this.getContextMonitor().registrarCreated((Registrar)registrar, registrarMonitor);
        return registrar;
    }

    private void loadRubyScriptFromClassLoader(String fileName, Ruby runtime) {
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder script = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                script.append(line).append("\n");
                line = bufferedReader.readLine();
            }
            runtime.executeScript(script.toString(), fileName);
        }
        catch (IOException e) {
            throw new WaffleException((Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

