/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.wsclient.services.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measure
extends Model {
    private String metricKey;
    private String metricName;
    private Double value;
    private String formattedValue;
    private String data;
    private String characteristicKey;
    private String characteristicName;
    private Integer trend;
    private Integer var;
    private String ruleKey;
    private String ruleName;
    private String ruleSeverity;
    @Deprecated
    private String ruleCategory;
    private Double variation1;
    private Double variation2;
    private Double variation3;
    private Double variation4;
    private Double variation5;

    public String getMetricKey() {
        return this.metricKey;
    }

    public Measure setMetricKey(String metricKey) {
        this.metricKey = metricKey;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Measure setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.intValue();
    }

    public Measure setValue(Double value) {
        this.value = value;
        return this;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public String getFormattedValue(String defaultValue) {
        if (this.formattedValue == null) {
            return defaultValue;
        }
        return this.formattedValue;
    }

    public Measure setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getDataAsMap() {
        return this.getDataAsMap(",");
    }

    public Map<String, String> getDataAsMap(String separator) {
        String[] parts;
        if (this.data == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String part : parts = this.data.split(separator)) {
            String[] kv = part.split("=");
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public Measure setData(String data) {
        this.data = data;
        return this;
    }

    public Integer getTrend() {
        return this.trend;
    }

    public Measure setTrend(Integer trend) {
        this.trend = trend;
        return this;
    }

    public Integer getVar() {
        return this.var;
    }

    public Measure setVar(Integer var) {
        this.var = var;
        return this;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public Measure setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Measure setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    @Deprecated
    public String getRuleCategory() {
        return this.ruleCategory;
    }

    @Deprecated
    public Measure setRuleCategory(String ruleCategory) {
        this.ruleCategory = ruleCategory;
        return this;
    }

    public Measure setRuleSeverity(String ruleSeverity) {
        this.ruleSeverity = ruleSeverity;
        return this;
    }

    public String getRuleSeverity() {
        return this.ruleSeverity;
    }

    @Deprecated
    public String getRulePriority() {
        return this.ruleSeverity;
    }

    @Deprecated
    public Measure setRulePriority(String rulePriority) {
        this.ruleSeverity = rulePriority;
        return this;
    }

    public String getCharacteristicKey() {
        return this.characteristicKey;
    }

    public String getCharacteristicName() {
        return this.characteristicName;
    }

    public Measure setCharacteristicKey(String s) {
        this.characteristicKey = s;
        return this;
    }

    public Measure setCharacteristicName(String s) {
        this.characteristicName = s;
        return this;
    }

    public Double getVariation1() {
        return this.variation1;
    }

    public Measure setVariation1(Double variation1) {
        this.variation1 = variation1;
        return this;
    }

    public Double getVariation2() {
        return this.variation2;
    }

    public Measure setVariation2(Double variation2) {
        this.variation2 = variation2;
        return this;
    }

    public Double getVariation3() {
        return this.variation3;
    }

    public Measure setVariation3(Double variation3) {
        this.variation3 = variation3;
        return this;
    }

    public Double getVariation4() {
        return this.variation4;
    }

    public Measure setVariation4(Double variation4) {
        this.variation4 = variation4;
        return this;
    }

    public Double getVariation5() {
        return this.variation5;
    }

    public Measure setVariation5(Double variation5) {
        this.variation5 = variation5;
        return this;
    }

    public String toString() {
        return "Measure{" + "metricKey='" + this.metricKey + '\'' + ", metricName='" + this.metricName + '\'' + ", value=" + this.value + ", formattedValue='" + this.formattedValue + '\'' + ", data='" + this.data + '\'' + ", characteristicKey='" + this.characteristicKey + '\'' + ", characteristicName='" + this.characteristicName + '\'' + ", trend=" + this.trend + ", var=" + this.var + ", ruleKey='" + this.ruleKey + '\'' + ", ruleName='" + this.ruleName + '\'' + ", ruleCategory='" + this.ruleCategory + '\'' + ", rulePriority='" + this.ruleSeverity + '\'' + '}';
    }
}

