/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulesManager;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;

@Deprecated
public abstract class AbstractViolationsStaxParser {
    protected RulesManager rulesManager;
    protected SensorContext context;
    protected boolean doSaveViolationsOnUnexistedResource = true;

    @Deprecated
    protected AbstractViolationsStaxParser(SensorContext context, RulesManager rulesManager, RulesProfile profile) {
        this.rulesManager = rulesManager;
        this.context = context;
    }

    protected AbstractViolationsStaxParser(SensorContext context, RulesManager rulesManager) {
        this.rulesManager = rulesManager;
        this.context = context;
    }

    protected abstract SMInputCursor cursorForResources(SMInputCursor var1) throws XMLStreamException;

    protected abstract SMInputCursor cursorForViolations(SMInputCursor var1) throws XMLStreamException;

    protected abstract Resource toResource(SMInputCursor var1) throws XMLStreamException;

    protected abstract String messageFor(SMInputCursor var1) throws XMLStreamException;

    protected abstract String ruleKey(SMInputCursor var1) throws XMLStreamException;

    protected abstract String keyForPlugin();

    protected abstract String lineNumberForViolation(SMInputCursor var1) throws XMLStreamException;

    public final void setDoSaveViolationsOnUnexistedResource(boolean doSaveViolationsOnUnexistedResource) {
        this.doSaveViolationsOnUnexistedResource = doSaveViolationsOnUnexistedResource;
    }

    public void parse(File violationsXMLFile) throws XMLStreamException {
        if (violationsXMLFile != null && violationsXMLFile.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(violationsXMLFile);
                this.parse(input);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new XMLStreamException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public final void parse(InputStream input) throws XMLStreamException {
        if (input != null) {
            StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

                public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                    AbstractViolationsStaxParser.this.parseResources(rootCursor.advance());
                }
            }, true);
            parser.parse(input);
        }
    }

    private void parseResources(SMInputCursor rootCursor) throws XMLStreamException {
        SMEvent event;
        SMInputCursor resourcesCursor = this.cursorForResources(rootCursor);
        while ((event = resourcesCursor.getNext()) != null) {
            if (event.compareTo((Enum)SMEvent.START_ELEMENT) != 0) continue;
            this.parseViolations(resourcesCursor);
        }
    }

    private void parseViolations(SMInputCursor resourcesCursor) throws XMLStreamException {
        SMEvent event;
        Resource resource = this.toResource(resourcesCursor);
        if (!this.doSaveViolationsOnUnexistedResource && this.context.getResource(resource) == null) {
            return;
        }
        SMInputCursor violationsCursor = this.cursorForViolations(resourcesCursor);
        while ((event = violationsCursor.getNext()) != null) {
            if (event.compareTo((Enum)SMEvent.START_ELEMENT) != 0) continue;
            this.createViolationFor(resource, violationsCursor);
        }
    }

    private void createViolationFor(Resource resource, SMInputCursor violationCursor) throws XMLStreamException {
        Rule rule = this.getRule(violationCursor);
        Integer line = this.getLineIndex(violationCursor);
        if (rule != null && resource != null) {
            Violation violation = Violation.create((Rule)rule, (Resource)resource).setLineId(line).setMessage(this.messageFor(violationCursor));
            this.context.saveViolation(violation);
        }
    }

    private Rule getRule(SMInputCursor violationCursor) throws XMLStreamException {
        return this.rulesManager.getPluginRule(this.keyForPlugin(), this.ruleKey(violationCursor));
    }

    private Integer getLineIndex(SMInputCursor violationCursor) throws XMLStreamException {
        String line = this.lineNumberForViolation(violationCursor);
        return AbstractViolationsStaxParser.parseLineIndex(line);
    }

    protected static Integer parseLineIndex(String line) {
        if (!StringUtils.isNotBlank((String)line) || line.indexOf(45) != -1) {
            return null;
        }
        try {
            return (int)ParsingUtils.parseNumber((String)line);
        }
        catch (ParseException ignore) {
            return null;
        }
    }
}

