/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.phases.DecoratorsExecutor;
import org.sonar.batch.phases.InitializersExecutor;
import org.sonar.batch.phases.MavenPhaseExecutor;
import org.sonar.batch.phases.MavenPluginsConfigurator;
import org.sonar.batch.phases.PostJobsExecutor;
import org.sonar.batch.phases.SensorsExecutor;
import org.sonar.batch.phases.UpdateStatusJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Phases {
    private DecoratorsExecutor decoratorsExecutor;
    private MavenPhaseExecutor mavenPhaseExecutor;
    private MavenPluginsConfigurator mavenPluginsConfigurator;
    private PostJobsExecutor postJobsExecutor;
    private InitializersExecutor initializersExecutor;
    private SensorsExecutor sensorsExecutor;
    private UpdateStatusJob updateStatusJob;
    private PersistenceManager persistenceManager;
    private SensorContext sensorContext;
    private DefaultIndex index;

    public static Collection<Class> getPhaseClasses() {
        return Arrays.asList(DecoratorsExecutor.class, MavenPhaseExecutor.class, MavenPluginsConfigurator.class, PostJobsExecutor.class, SensorsExecutor.class, UpdateStatusJob.class, InitializersExecutor.class);
    }

    public Phases(DecoratorsExecutor decoratorsExecutor, MavenPhaseExecutor mavenPhaseExecutor, MavenPluginsConfigurator mavenPluginsConfigurator, InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, UpdateStatusJob updateStatusJob, PersistenceManager persistenceManager, SensorContext sensorContext, DefaultIndex index) {
        this.decoratorsExecutor = decoratorsExecutor;
        this.mavenPhaseExecutor = mavenPhaseExecutor;
        this.mavenPluginsConfigurator = mavenPluginsConfigurator;
        this.postJobsExecutor = postJobsExecutor;
        this.initializersExecutor = initializersExecutor;
        this.sensorsExecutor = sensorsExecutor;
        this.updateStatusJob = updateStatusJob;
        this.persistenceManager = persistenceManager;
        this.sensorContext = sensorContext;
        this.index = index;
    }

    public void execute(Project project) {
        this.mavenPluginsConfigurator.execute(project);
        this.mavenPhaseExecutor.execute(project);
        this.initializersExecutor.execute(project);
        this.persistenceManager.setDelayedMode(true);
        this.sensorsExecutor.execute(project, this.sensorContext);
        this.decoratorsExecutor.execute(project);
        this.persistenceManager.dump();
        this.persistenceManager.setDelayedMode(false);
        if (project.isRoot()) {
            this.updateStatusJob.execute();
            this.postJobsExecutor.execute(project, this.sensorContext);
        }
        this.cleanMemory();
    }

    private void cleanMemory() {
        this.persistenceManager.clear();
        this.index.clear();
    }
}

