/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.batch.index.ResourcePersister;

public final class ViolationPersister {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;
    private RuleFinder ruleFinder;

    public ViolationPersister(DatabaseSession session, ResourcePersister resourcePersister, RuleFinder ruleFinder) {
        this.session = session;
        this.resourcePersister = resourcePersister;
        this.ruleFinder = ruleFinder;
    }

    void saveViolation(Project project, Violation violation) {
        this.saveViolation(project, violation, null);
    }

    public void saveViolation(Project project, Violation violation, String checksum) {
        Snapshot snapshot = this.resourcePersister.saveResource(project, violation.getResource());
        if (violation.getCreatedAt() == null) {
            violation.setCreatedAt(snapshot.getCreatedAt());
        }
        RuleFailureModel model = this.createModel(violation);
        model.setSnapshotId(snapshot.getId());
        model.setChecksum(checksum);
        this.session.save((Object)model);
        violation.setMessage(model.getMessage());
    }

    private RuleFailureModel createModel(Violation violation) {
        RuleFailureModel model = new RuleFailureModel();
        Rule rule = this.ruleFinder.findByKey(violation.getRule().getRepositoryKey(), violation.getRule().getKey());
        model.setRuleId(rule.getId());
        model.setPriority(violation.getSeverity());
        model.setCreatedAt(violation.getCreatedAt());
        model.setLine(violation.getLineId());
        model.setMessage(violation.getMessage());
        model.setCost(violation.getCost());
        return model;
    }
}

