/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.ActiveRule;
import org.sonar.batch.ProfileLoader;
import org.sonar.jpa.dao.ProfilesDao;

public class DefaultProfileLoader
implements ProfileLoader {
    static final String PARAM_PROFILE = "sonar.profile";
    private RulesProfile profile;
    private ProfilesDao dao;

    public DefaultProfileLoader(ProfilesDao dao) {
        this.dao = dao;
    }

    public RulesProfile load(Project project) {
        String profileName = (String)project.getProperty(PARAM_PROFILE);
        if (profileName == null) {
            Project root = project.getRoot();
            this.profile = this.dao.getActiveProfile(root.getLanguageKey(), root.getKey());
            if (this.profile == null) {
                throw new RuntimeException("Quality profile not found for " + root.getKey() + ", language " + root.getLanguageKey());
            }
        } else {
            this.profile = this.dao.getProfile(project.getLanguageKey(), profileName);
            if (this.profile == null) {
                throw new RuntimeException("Quality profile not found : " + profileName + ", language " + project.getLanguageKey());
            }
        }
        this.profile.getActiveRules().size();
        for (ActiveRule activeRule : this.profile.getActiveRules()) {
            activeRule.getActiveRuleParams().size();
            activeRule.getRule().getParams().size();
        }
        this.profile.getAlerts().size();
        return this.profile;
    }
}

