/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDecoratorContext
implements DecoratorContext {
    private SonarIndex index;
    private Resource resource;
    private boolean readOnly = false;
    private List<DecoratorContext> childrenContexts;

    public DefaultDecoratorContext(Resource resource, SonarIndex index, List<DecoratorContext> childrenContexts) {
        this.index = index;
        this.resource = resource;
        this.childrenContexts = childrenContexts;
    }

    public DefaultDecoratorContext setReadOnly(boolean b) {
        this.readOnly = b;
        this.childrenContexts = null;
        return this;
    }

    public Project getProject() {
        return this.index.getProject();
    }

    public List<DecoratorContext> getChildren() {
        this.checkReadOnly("getModules");
        return this.childrenContexts;
    }

    private void checkReadOnly(String methodName) {
        if (this.readOnly) {
            throw new IllegalStateException("Method DecoratorContext." + methodName + "() can not be executed on children.");
        }
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        return (M)this.index.getMeasures(this.resource, filter);
    }

    public Measure getMeasure(Metric metric) {
        return this.index.getMeasure(this.resource, metric);
    }

    public Collection<Measure> getChildrenMeasures(MeasuresFilter filter) {
        ArrayList result = Lists.newArrayList();
        for (DecoratorContext childContext : this.childrenContexts) {
            Object childResult = childContext.getMeasures(filter);
            if (childResult == null) continue;
            if (childResult instanceof Collection) {
                result.addAll((Collection)childResult);
                continue;
            }
            result.add((Measure)childResult);
        }
        return result;
    }

    public Collection<Measure> getChildrenMeasures(Metric metric) {
        return this.getChildrenMeasures(MeasuresFilters.metric((Metric)metric));
    }

    public Resource getResource() {
        return this.resource;
    }

    public DecoratorContext saveMeasure(Measure measure) {
        this.checkReadOnly("saveMeasure");
        this.index.addMeasure(this.resource, measure);
        return this;
    }

    public DecoratorContext saveMeasure(Metric metric, Double value) {
        this.checkReadOnly("saveMeasure");
        this.index.addMeasure(this.resource, new Measure(metric, value));
        return this;
    }

    public List<Violation> getViolations() {
        return this.index.getViolations(this.resource);
    }

    public Dependency saveDependency(Dependency dependency) {
        this.checkReadOnly("addDependency");
        return this.index.addDependency(dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.index.getDependencies();
    }

    public Collection<Dependency> getIncomingDependencies() {
        return this.index.getIncomingEdges((Object)this.resource);
    }

    public Collection<Dependency> getOutgoingDependencies() {
        return this.index.getOutgoingEdges((Object)this.resource);
    }

    public List<Event> getEvents() {
        return this.index.getEvents(this.resource);
    }

    public Event createEvent(String name, String description, String category, Date date) {
        return this.index.addEvent(this.resource, name, description, category, date);
    }

    public void deleteEvent(Event event) {
        this.index.deleteEvent(event);
    }

    public DefaultDecoratorContext saveViolation(Violation violation, boolean force) {
        if (violation.getResource() == null) {
            violation.setResource(this.resource);
        }
        this.index.addViolation(violation, force);
        return this;
    }

    public DefaultDecoratorContext saveViolation(Violation violation) {
        return this.saveViolation(violation, false);
    }
}

