/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.Extension;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.core.NotDryRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionUtils {
    private ExtensionUtils() {
    }

    static boolean isInstantiationStrategy(Object extension, String strategy) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        InstantiationStrategy extStrategy = (InstantiationStrategy)AnnotationUtils.getClassAnnotation(clazz, InstantiationStrategy.class);
        if (extStrategy != null) {
            return strategy.equals(extStrategy.value());
        }
        return "PER_PROJECT".equals(strategy);
    }

    static boolean isBatchExtension(Object extension) {
        return ExtensionUtils.isType(extension, BatchExtension.class);
    }

    static boolean isSupportedEnvironment(Object extension, EnvironmentInformation environment) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getClassAnnotation(clazz, SupportedEnvironment.class);
        if (env == null) {
            return true;
        }
        for (String supported : env.value()) {
            if (!StringUtils.equalsIgnoreCase((String)environment.getKey(), (String)supported)) continue;
            return true;
        }
        return false;
    }

    static boolean checkDryRun(Object extension, boolean dryRun) {
        return !dryRun || AnnotationUtils.getClassAnnotation((Object)extension, NotDryRun.class) == null;
    }

    static boolean isMavenExtensionOnly(Object extension) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getClassAnnotation(clazz, SupportedEnvironment.class);
        return env != null && env.value().length == 1 && StringUtils.equalsIgnoreCase((String)"maven", (String)env.value()[0]);
    }

    static boolean isType(Object extension, Class<? extends Extension> extensionClass) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        return extensionClass.isAssignableFrom(clazz);
    }
}

