/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.home.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import org.sonar.runner.commonsio.IOUtils;

public class FileHashes {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public String of(File file) {
        try {
            return this.of(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to compute hash of: " + file.getAbsolutePath(), e);
        }
    }

    public String of(InputStream input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = this.digest(input, digest);
            String string = FileHashes.toHex(hash);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to compute hash", e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    private byte[] digest(InputStream input, MessageDigest digest) throws IOException {
        byte[] buffer = new byte[1024];
        int read = input.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = input.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "x", bi);
    }
}

