/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import org.sonar.runner.Cli;
import org.sonar.runner.Conf;
import org.sonar.runner.Exit;
import org.sonar.runner.RunnerFactory;
import org.sonar.runner.Stats;
import org.sonar.runner.SystemInfo;
import org.sonar.runner.impl.Logs;

public class Main {
    private final Exit exit;
    private final Cli cli;
    private final Conf conf;
    private final RunnerFactory runnerFactory;

    Main(Exit exit, Cli cli, Conf conf, RunnerFactory runnerFactory) {
        this.exit = exit;
        this.cli = cli;
        this.conf = conf;
        this.runnerFactory = runnerFactory;
    }

    public static void main(String[] args) {
        Cli cli = new Cli().parse(args);
        Main main = new Main(new Exit(), cli, new Conf(cli), new RunnerFactory());
        main.execute();
    }

    void execute() {
        SystemInfo.print();
        if (!this.cli.isDisplayVersionOnly()) {
            int status = this.executeTask();
            this.exit.exit(status);
        }
    }

    private int executeTask() {
        Stats stats = new Stats().start();
        try {
            if (this.cli.isDisplayStackTrace()) {
                Logs.info("Error stacktraces are turned on.");
            }
            this.runnerFactory.create(this.conf.properties()).execute();
        }
        catch (Exception e) {
            this.displayExecutionResult(stats, "FAILURE");
            this.showError("Error during Sonar runner execution", e, this.cli.isDisplayStackTrace());
            return 1;
        }
        this.displayExecutionResult(stats, "SUCCESS");
        return 0;
    }

    private void displayExecutionResult(Stats stats, String resultMsg) {
        Logs.info("------------------------------------------------------------------------");
        Logs.info("EXECUTION " + resultMsg);
        Logs.info("------------------------------------------------------------------------");
        stats.stop();
        Logs.info("------------------------------------------------------------------------");
    }

    public void showError(String message, Throwable e, boolean showStackTrace) {
        if (showStackTrace) {
            Logs.error(message, e);
            if (!this.cli.isDebugMode()) {
                Logs.error("");
                this.suggestDebugMode();
            }
        } else {
            Logs.error(message);
            if (e != null) {
                Logs.error(e.getMessage());
                String previousMsg = "";
                for (Throwable cause = e.getCause(); cause != null && cause.getMessage() != null && !cause.getMessage().equals(previousMsg); cause = cause.getCause()) {
                    Logs.error("Caused by: " + cause.getMessage());
                    previousMsg = cause.getMessage();
                }
            }
            Logs.error("");
            Logs.error("To see the full stack trace of the errors, re-run SonarQube Runner with the -e switch.");
            if (!this.cli.isDebugMode()) {
                this.suggestDebugMode();
            }
        }
    }

    private void suggestDebugMode() {
        Logs.error("Re-run SonarQube Runner using the -X switch to enable full debug logging.");
    }
}

