/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.sonar.runner.Cli;
import org.sonar.runner.impl.Logs;

class Conf {
    private static final String RUNNER_HOME = "runner.home";
    private static final String RUNNER_SETTINGS = "runner.settings";
    private static final String PROJECT_HOME = "project.home";
    private static final String PROJECT_SETTINGS = "project.settings";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_PROJECT_CONFIG_FILE = "sonar.projectConfigFile";
    private static final String SONAR_PROJECT_PROPERTIES_FILENAME = "sonar-project.properties";
    private final Cli cli;

    Conf(Cli cli) {
        this.cli = cli;
    }

    Properties properties() throws IOException {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.loadGlobalProperties());
        result.putAll((Map<?, ?>)this.loadProjectProperties());
        result.putAll((Map<?, ?>)System.getProperties());
        result.putAll((Map<?, ?>)this.cli.properties());
        result.remove(PROJECT_HOME);
        return result;
    }

    private Properties loadGlobalProperties() throws IOException {
        File settingsFile = this.locatePropertiesFile(this.cli.properties(), RUNNER_HOME, "conf/sonar-runner.properties", RUNNER_SETTINGS);
        if (settingsFile != null && settingsFile.isFile() && settingsFile.exists()) {
            Logs.info("Runner configuration file: " + settingsFile.getAbsolutePath());
            return Conf.toProperties(settingsFile);
        }
        Logs.info("Runner configuration file: NONE");
        return new Properties();
    }

    private Properties loadProjectProperties() throws IOException {
        Properties cliProps;
        File rootSettingsFile = this.locatePropertiesFile(cliProps, (cliProps = this.cli.properties()).containsKey(PROPERTY_PROJECT_BASEDIR) ? PROPERTY_PROJECT_BASEDIR : PROJECT_HOME, SONAR_PROJECT_PROPERTIES_FILENAME, PROJECT_SETTINGS);
        if (rootSettingsFile != null && rootSettingsFile.isFile() && rootSettingsFile.exists()) {
            Logs.info("Project configuration file: " + rootSettingsFile.getAbsolutePath());
            Properties projectProps = new Properties();
            Properties rootProps = Conf.toProperties(rootSettingsFile);
            projectProps.putAll((Map<?, ?>)rootProps);
            this.initRootProjectBaseDir(cliProps, rootProps);
            this.loadModulesProperties(rootProps, projectProps, "");
            return projectProps;
        }
        Logs.info("Project configuration file: NONE");
        return new Properties();
    }

    private void initRootProjectBaseDir(Properties cliProps, Properties rootProps) {
        if (!cliProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            String baseDir = cliProps.getProperty(PROJECT_HOME);
            rootProps.put(PROPERTY_PROJECT_BASEDIR, baseDir);
        } else {
            rootProps.put(PROPERTY_PROJECT_BASEDIR, cliProps.getProperty(PROPERTY_PROJECT_BASEDIR));
        }
    }

    private void loadModulesProperties(Properties parentProps, Properties projectProps, String prefix) {
        File parentBaseDir = new File(parentProps.getProperty(PROPERTY_PROJECT_BASEDIR));
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String module : Conf.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                Properties moduleProps = Conf.extractModuleProperties(module, parentProps);
                moduleProps = this.loadChildConfigFile(parentBaseDir, moduleProps, module);
                this.loadModulesProperties(moduleProps, projectProps, module + ".");
                this.merge(projectProps, prefix, module, moduleProps);
            }
        }
    }

    private void merge(Properties projectProps, String prefix, String module, Properties moduleProps) {
        for (Map.Entry<Object, Object> entry : moduleProps.entrySet()) {
            projectProps.put(prefix + module + "." + entry.getKey(), entry.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadChildConfigFile(File parentBaseDir, Properties moduleProps, String moduleId) {
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            File baseDir = Conf.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), parentBaseDir);
            Conf.setProjectBaseDir(baseDir, moduleProps, moduleId);
            try {
                if (parentBaseDir.getCanonicalFile().equals(baseDir.getCanonicalFile())) return moduleProps;
                this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
                return moduleProps;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error when resolving baseDir", e);
            }
        } else if (moduleProps.containsKey(PROPERTY_PROJECT_CONFIG_FILE)) {
            File baseDir = this.loadPropsFile(parentBaseDir, moduleProps, moduleId);
            Conf.setProjectBaseDir(baseDir, moduleProps, moduleId);
            moduleProps.remove(PROPERTY_PROJECT_CONFIG_FILE);
            return moduleProps;
        } else {
            File baseDir = new File(parentBaseDir, moduleId);
            Conf.setProjectBaseDir(baseDir, moduleProps, moduleId);
            this.tryToFindAndLoadPropsFile(baseDir, moduleProps, moduleId);
        }
        return moduleProps;
    }

    private static void setProjectBaseDir(File baseDir, Properties childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw new IllegalStateException(MessageFormat.format("The base directory of the module ''{0}'' does not exist: {1}", moduleId, baseDir.getAbsolutePath()));
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    protected static Properties extractModuleProperties(String module, Properties properties) {
        Properties moduleProps = new Properties();
        String propertyPrefix = module + ".";
        int prefixLength = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(propertyPrefix)) continue;
            moduleProps.put(key.substring(prefixLength), entry.getValue());
        }
        return moduleProps;
    }

    private File locatePropertiesFile(Properties props, String homeKey, String relativePathFromHome, String settingsKey) {
        String settingsPath;
        File settingsFile = null;
        String runnerHome = props.getProperty(homeKey, "");
        if (!"".equals(runnerHome)) {
            settingsFile = new File(runnerHome, relativePathFromHome);
        }
        if (!(settingsFile != null && settingsFile.exists() || "".equals(settingsPath = props.getProperty(settingsKey, "")))) {
            settingsFile = new File(settingsPath);
        }
        return settingsFile;
    }

    private static Properties toProperties(File file) {
        InputStream in = null;
        try {
            Properties properties = new Properties();
            in = new FileInputStream(file);
            properties.load(in);
            for (String propKey : properties.stringPropertyNames()) {
                properties.setProperty(propKey, properties.getProperty(propKey).trim());
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to load file: " + file.getAbsolutePath(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected File loadPropsFile(File parentBaseDir, Properties moduleProps, String moduleId) {
        File propertyFile = Conf.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_CONFIG_FILE), parentBaseDir);
        if (propertyFile.isFile()) {
            Properties propsFromFile = Conf.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
            File baseDir = null;
            baseDir = moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR) ? Conf.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile()) : propertyFile.getParentFile();
            Conf.setProjectBaseDir(baseDir, moduleProps, moduleId);
            return baseDir;
        }
        throw new IllegalStateException("The properties file of the module '" + moduleId + "' does not exist: " + propertyFile.getAbsolutePath());
    }

    private void tryToFindAndLoadPropsFile(File baseDir, Properties moduleProps, String moduleId) {
        File propertyFile = new File(baseDir, SONAR_PROJECT_PROPERTIES_FILENAME);
        if (propertyFile.isFile()) {
            Properties propsFromFile = Conf.toProperties(propertyFile);
            for (Map.Entry<Object, Object> entry : propsFromFile.entrySet()) {
                moduleProps.put(entry.getKey(), entry.getValue());
            }
            if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
                File overwrittenBaseDir = Conf.getFileFromPath(moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR), propertyFile.getParentFile());
                Conf.setProjectBaseDir(overwrittenBaseDir, moduleProps, moduleId);
            }
        }
    }

    protected static File getFileFromPath(String path, File baseDir) {
        File propertyFile = new File(path.trim());
        if (!propertyFile.isAbsolute()) {
            propertyFile = new File(baseDir, propertyFile.getPath());
        }
        return propertyFile;
    }

    static String[] getListFromProperty(Properties properties, String key) {
        String value = properties.getProperty(key, "");
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }
}

