/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.runner.api.Command;
import org.sonar.runner.api.CommandExecutor;
import org.sonar.runner.api.Os;
import org.sonar.runner.api.PrintStreamConsumer;
import org.sonar.runner.api.ProcessMonitor;
import org.sonar.runner.api.Runner;
import org.sonar.runner.api.StreamConsumer;
import org.sonar.runner.commonsio.FileUtils;
import org.sonar.runner.commonsio.IOUtils;
import org.sonar.runner.impl.BatchLauncherMain;
import org.sonar.runner.impl.JarExtractor;

public class ForkedRunner
extends Runner<ForkedRunner> {
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    private final Map<String, String> jvmEnvVariables = new HashMap<String, String>();
    private final List<String> jvmArguments = new ArrayList<String>();
    private String javaExecutable;
    private StreamConsumer stdOut = null;
    private StreamConsumer stdErr = null;
    private final JarExtractor jarExtractor;
    private final CommandExecutor commandExecutor;
    private ProcessMonitor processMonitor;

    ForkedRunner(JarExtractor jarExtractor, CommandExecutor commandExecutor, @Nullable ProcessMonitor processMonitor) {
        this.jarExtractor = jarExtractor;
        this.commandExecutor = commandExecutor;
        this.processMonitor = processMonitor;
    }

    ForkedRunner(JarExtractor jarExtractor, CommandExecutor commandExecutor) {
        this(jarExtractor, commandExecutor, null);
    }

    public static ForkedRunner create() {
        return new ForkedRunner(new JarExtractor(), CommandExecutor.create());
    }

    public static ForkedRunner create(ProcessMonitor processMonitor) {
        return new ForkedRunner(new JarExtractor(), CommandExecutor.create(), processMonitor);
    }

    public ForkedRunner setJavaExecutable(@Nullable String s) {
        this.javaExecutable = s;
        return this;
    }

    public List<String> jvmArguments() {
        return new ArrayList<String>(this.jvmArguments);
    }

    public ForkedRunner addJvmArguments(String ... s) {
        return this.addJvmArguments(Arrays.asList(s));
    }

    public ForkedRunner addJvmArguments(List<String> args) {
        this.jvmArguments.addAll(args);
        return this;
    }

    public ForkedRunner setJvmEnvVariable(String key, String value) {
        this.jvmEnvVariables.put(key, value);
        return this;
    }

    public ForkedRunner addJvmEnvVariables(Map<String, String> map) {
        this.jvmEnvVariables.putAll(map);
        return this;
    }

    public ForkedRunner setStdOut(@Nullable StreamConsumer stream) {
        this.stdOut = stream;
        return this;
    }

    public ForkedRunner setStdErr(@Nullable StreamConsumer stream) {
        this.stdErr = stream;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() {
        ForkCommand forkCommand = this.createCommand();
        try {
            this.fork(forkCommand);
        }
        finally {
            this.deleteTempFiles(forkCommand);
        }
    }

    ForkCommand createCommand() {
        File propertiesFile = this.writeProperties();
        File jarFile = this.jarExtractor.extractToTemp("sonar-runner-impl");
        if (this.javaExecutable == null) {
            this.javaExecutable = new Os().thisJavaExe().getAbsolutePath();
        }
        Command command = Command.builder().setExecutable(this.javaExecutable).addEnvVariables(this.jvmEnvVariables).addArguments(this.jvmArguments).addArguments("-cp", jarFile.getAbsolutePath(), BatchLauncherMain.class.getName(), propertiesFile.getAbsolutePath()).build();
        return new ForkCommand(command, jarFile, propertiesFile);
    }

    private File writeProperties() {
        File file;
        FileOutputStream output = null;
        try {
            File file2 = File.createTempFile("sonar-project", ".properties");
            output = new FileOutputStream(file2);
            this.properties().store(output, "Generated by sonar-runner");
            file = file2;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Fail to export sonar-runner properties", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(output);
        return file;
    }

    private void deleteTempFiles(ForkCommand forkCommand) {
        FileUtils.deleteQuietly(forkCommand.jarFile);
        FileUtils.deleteQuietly(forkCommand.propertiesFile);
    }

    private void fork(ForkCommand forkCommand) {
        int status;
        if (this.stdOut == null) {
            this.stdOut = new PrintStreamConsumer(System.out);
        }
        if (this.stdErr == null) {
            this.stdErr = new PrintStreamConsumer(System.err);
        }
        if ((status = this.commandExecutor.execute(forkCommand.command, this.stdOut, this.stdErr, 86400000L, this.processMonitor)) != 0) {
            if (this.processMonitor != null && this.processMonitor.stop()) {
                this.stdOut.consumeLine(String.format("SonarQube Runner was stopped [status=%s]", status));
            } else {
                throw new IllegalStateException("Error status [command: " + forkCommand.command + "]: " + status);
            }
        }
    }

    static class ForkCommand {
        Command command;
        File jarFile;
        File propertiesFile;

        private ForkCommand(Command command, File jarFile, File propertiesFile) {
            this.command = command;
            this.jarFile = jarFile;
            this.propertiesFile = propertiesFile;
        }
    }
}

