/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.test;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.ide.test.SonarTestServer;

public abstract class SonarIdeTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SonarIdeTestCase.class);
    private static final ReadWriteLock copyProjectLock = new ReentrantReadWriteLock();
    protected static File projectsSource;
    protected static File projectsWorkdir;
    protected static SonarTestServer testServer;

    @BeforeClass
    public static void init() throws Exception {
        projectsSource = new File("target/projects-source");
        projectsWorkdir = new File("target/projects-target");
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (testServer != null) {
            testServer.stop();
            testServer = null;
        }
    }

    protected SonarTestServer getTestServer() throws Exception {
        if (testServer == null) {
            testServer = new SonarTestServer();
            testServer.start();
        }
        return testServer;
    }

    protected static String getProjectKey(File project) {
        String projectName = project.getName();
        return "org.sonar-ide.tests." + projectName + ":" + projectName;
    }

    protected static File getProjectFile(File project, String filename) {
        return new File(project, filename);
    }

    protected static File getProject(String projectName) throws IOException {
        File destDir = new File(projectsWorkdir, projectName);
        return SonarIdeTestCase.getProject(projectName, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File getProject(String projectName, File destDir) throws IOException {
        copyProjectLock.writeLock().lock();
        try {
            File projectFolder = new File(projectsSource, projectName);
            Assert.assertTrue((String)("Project " + projectName + " folder not found.\n" + projectFolder.getAbsolutePath()), (boolean)projectFolder.isDirectory());
            if (destDir.isDirectory()) {
                LOG.warn("Directory for project already exists: {}", (Object)destDir);
            }
            FileUtils.copyDirectory((File)projectFolder, (File)destDir);
            File file = destDir;
            return file;
        }
        finally {
            copyProjectLock.writeLock().unlock();
        }
    }
}

