/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class HttpServer {
    private Server server;
    private int httpPort;
    private int httpsPort = -1;
    private String keyStoreLocation = "resources/ssl/keystore";
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private boolean needClientAuth;
    private String proxyUsername;
    private String proxyPassword;
    private boolean redirectToHttps;
    private long latency;
    private Map<String, String> userPasswords = new HashMap<String, String>();
    private Map<String, String[]> userRoles = new HashMap<String, String[]>();
    private Map<String, String[]> securedRealms = new HashMap<String, String[]>();
    private String baseDir;
    private Context context = new Context(3);

    public HttpServer setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public int getHttpPort() {
        if (this.httpPort >= 0 && this.server != null && this.server.isRunning()) {
            return this.server.getConnectors()[0].getLocalPort();
        }
        return this.httpPort;
    }

    public String getHttpUrl() {
        return "http://localhost:" + this.getHttpPort();
    }

    public HttpServer setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public int getHttpsPort() {
        if (this.httpsPort >= 0 && this.server != null && this.server.isRunning()) {
            return this.server.getConnectors()[this.httpPort < 0 ? 0 : 1].getLocalPort();
        }
        return this.httpsPort;
    }

    public HttpServer setKeyStore(String path, String password) {
        this.keyStoreLocation = path;
        this.keyStorePassword = password;
        return this;
    }

    public HttpServer setTrustStore(String path, String password) {
        this.trustStoreLocation = path;
        this.trustStorePassword = password;
        return this;
    }

    public HttpServer setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public HttpServer setLatency(long millis) {
        this.latency = millis;
        return this;
    }

    public HttpServer setProxyAuth(String username, String password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    public HttpServer setRedirectToHttps(boolean redirectToHttps) {
        this.redirectToHttps = redirectToHttps;
        return this;
    }

    public HttpServer addUser(String username, String password, String ... roles) {
        this.userPasswords.put(username, password);
        this.userRoles.put(username, roles == null ? new String[]{} : roles);
        return this;
    }

    public HttpServer addSecuredRealm(String pathSpec, String ... roles) {
        this.securedRealms.put(pathSpec, roles == null ? new String[]{} : roles);
        return this;
    }

    protected Connector newHttpConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.httpPort);
        return connector;
    }

    protected Connector newHttpsConnector() {
        SslSocketConnector connector = new SslSocketConnector();
        connector.setPort(this.httpsPort);
        connector.setKeystore(new File(this.keyStoreLocation).getAbsolutePath());
        connector.setPassword(this.keyStorePassword);
        connector.setKeyPassword(this.keyStorePassword);
        connector.setTruststore(new File(this.trustStoreLocation).getAbsolutePath());
        connector.setTrustPassword(this.trustStorePassword);
        connector.setNeedClientAuth(this.needClientAuth);
        return connector;
    }

    protected Handler newSleepHandler(final long millis) {
        return new AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
                if (millis >= 0L) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    1 var5_6 = this;
                    synchronized (var5_6) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            public String toString() {
                return "SleepHandler";
            }
        };
    }

    protected Handler newProxyHandler() {
        return new AbstractHandler(){

            public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
                String auth = request.getHeader("Proxy-Authorization");
                if (auth != null) {
                    auth = auth.substring(auth.indexOf(32) + 1).trim();
                    auth = B64Code.decode((String)auth);
                }
                if (!(HttpServer.this.proxyUsername + ':' + HttpServer.this.proxyPassword).equals(auth)) {
                    response.setStatus(407);
                    response.addHeader("Proxy-Authenticate", "Basic realm=\"Squid proxy-caching web server\"");
                    response.getWriter().println("Proxy authentication required");
                    ((Request)request).setHandled(true);
                }
            }

            public String toString() {
                return "ProxyHandler";
            }
        };
    }

    protected Handler newSslRedirectHandler() {
        return new AbstractHandler(){

            public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) {
                int httpsPort = HttpServer.this.getHttpsPort();
                if (!((Request)request).isHandled() && request.getServerPort() != httpsPort) {
                    String url = "https://" + request.getServerName() + ":" + httpsPort + request.getRequestURI();
                    response.setStatus(301);
                    response.setHeader("Location", url);
                    ((Request)request).setHandled(true);
                }
            }

            public String toString() {
                return "SslRedirectHandler";
            }
        };
    }

    protected Handler newSecurityHandler() {
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        for (String pathSpec : this.securedRealms.keySet()) {
            String[] roles = this.securedRealms.get(pathSpec);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setRoles(roles);
            constraint.setAuthenticate(true);
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint);
            constraintMapping.setPathSpec(pathSpec);
            mappings.add(constraintMapping);
        }
        HashUserRealm userRealm = new HashUserRealm("TestRealm");
        for (String username : this.userPasswords.keySet()) {
            String password = this.userPasswords.get(username);
            String[] roles = this.userRoles.get(username);
            userRealm.put((Object)username, (Object)password);
            if (roles == null) continue;
            for (String role : roles) {
                userRealm.addUserToRole(username, role);
            }
        }
        SecurityHandler securityHandler = new SecurityHandler();
        securityHandler.setUserRealm((UserRealm)userRealm);
        securityHandler.setConstraintMappings(mappings.toArray(new ConstraintMapping[mappings.size()]));
        return securityHandler;
    }

    public HttpServer start() throws Exception {
        if (this.server != null) {
            return this;
        }
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        if (this.httpPort >= 0) {
            connectors.add(this.newHttpConnector());
        }
        if (this.httpsPort >= 0 && this.keyStoreLocation != null) {
            connectors.add(this.newHttpsConnector());
        }
        HandlerList handlerList = new HandlerList();
        if (this.latency != 0L) {
            handlerList.addHandler(this.newSleepHandler(this.latency));
        }
        if (this.redirectToHttps) {
            handlerList.addHandler(this.newSslRedirectHandler());
        }
        if (this.proxyUsername != null && this.proxyPassword != null) {
            handlerList.addHandler(this.newProxyHandler());
        }
        if (!this.securedRealms.isEmpty()) {
            handlerList.addHandler(this.newSecurityHandler());
        }
        handlerList.addHandler((Handler)this.context);
        handlerList.addHandler((Handler)new DefaultHandler());
        this.server = new Server(0);
        this.server.setSendServerVersion(false);
        this.server.setHandler((Handler)handlerList);
        this.server.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        this.server.start();
        return this;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server = null;
        }
    }

    protected HttpServer setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public HttpServer setContextPath(String contextPath) {
        this.context.setContextPath(contextPath);
        return this;
    }

    public HttpServer addServlet(Class servlet, String pathSpec) {
        ServletHolder servletHolder = this.context.addServlet(servlet, pathSpec);
        servletHolder.setInitParameter("baseDir", this.baseDir);
        return this;
    }
}

