/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceUtils<MODEL> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceUtils.class);
    private static final char DELIMITER = ':';
    private static final char PACKAGE_DELIMITER = '.';
    private static final char PATH_DELIMITER = '/';
    public static final String DEFAULT_PACKAGE_NAME = "[default]";
    public static final String ROOT = "[root]";

    public final String getProjectKey(String groupId, String artifactId, String branch) {
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId)) {
            return null;
        }
        StringBuilder sb = new StringBuilder().append(groupId).append(':').append(artifactId);
        if (StringUtils.isNotBlank((String)branch)) {
            sb.append(':').append(branch);
        }
        return sb.toString();
    }

    @Deprecated
    public final String getProjectKey(String groupId, String artifactId) {
        return this.getProjectKey(groupId, artifactId, null);
    }

    public final String getComponentKey(MODEL file) {
        String componentName;
        String result = null;
        String projectKey = this.getProjectKey(file);
        if (this.isJavaFile(file)) {
            componentName = this.getPackageName(file);
            if (StringUtils.isWhitespace((String)componentName)) {
                componentName = DEFAULT_PACKAGE_NAME;
            }
        } else {
            componentName = this.getDirectoryPath(file);
            if (StringUtils.isWhitespace((String)componentName)) {
                componentName = ROOT;
            }
        }
        if (projectKey != null && componentName != null) {
            result = projectKey + ':' + componentName;
        }
        LOG.info("Component key for {} is {}", file, result);
        return result;
    }

    public final String getFileKey(MODEL file) {
        String result = null;
        String componentKey = this.getComponentKey(file);
        if (componentKey != null) {
            String fileName = this.getFileName(file);
            result = this.isJavaFile(file) ? componentKey + '.' + fileName : componentKey + '/' + fileName;
        }
        LOG.info("Resource key for {} is {}", file, result);
        return result;
    }

    protected abstract boolean isJavaFile(MODEL var1);

    protected abstract String getFileName(MODEL var1);

    protected abstract String getPackageName(MODEL var1);

    protected abstract String getDirectoryPath(MODEL var1);

    public abstract String getProjectKey(MODEL var1);
}

