/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;

public class QDoxModuleInfoParser {
    public JavaModuleDescriptor fromSourcePath(Path path) throws IOException {
        return this.fromSourcePath(path.toFile());
    }

    public JavaModuleDescriptor fromSourcePath(String path) throws IOException {
        return this.fromSourcePath(new File(path));
    }

    public JavaModuleDescriptor fromSourcePath(File path) throws IOException {
        JavaModuleDescriptor.Builder builder;
        File moduleDescriptor = new File(path, "module-info.java");
        if (moduleDescriptor.exists()) {
            com.thoughtworks.qdox.model.JavaModuleDescriptor descriptor = new JavaProjectBuilder().addSourceFolder(path).getDescriptor();
            builder = JavaModuleDescriptor.newModule(descriptor.getName());
            for (JavaModuleDescriptor.JavaRequires requires : descriptor.getRequires()) {
                builder.requires(requires.getModule().getName());
            }
            for (JavaModuleDescriptor.JavaExports exports : descriptor.getExports()) {
                if (exports.getTargets().isEmpty()) {
                    builder.exports(exports.getSource().getName());
                    continue;
                }
                LinkedHashSet<String> targets = new LinkedHashSet<String>();
                for (JavaModule module : exports.getTargets()) {
                    targets.add(module.getName());
                }
                builder.exports(exports.getSource().getName(), targets);
            }
        } else {
            builder = JavaModuleDescriptor.newAutomaticModule(null);
        }
        return builder.build();
    }
}

