/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.languages.java.jpms.AsmModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.JarModuleNameExtractor;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ManifestModuleNameExtractor;
import org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

public class LocationManager {
    private ModuleInfoParser asmParser;

    public LocationManager() {
        this.asmParser = new AsmModuleInfoParser();
    }

    LocationManager(ModuleInfoParser asmParser) {
        this.asmParser = asmParser;
    }

    public <T> ResolvePathsResult<T> resolvePaths(ResolvePathsRequest<T> request) throws IOException {
        ResolvePathsResult result = request.createResult();
        LinkedHashMap<T, JavaModuleDescriptor> pathElements = new LinkedHashMap<T, JavaModuleDescriptor>(request.getPathElements().size());
        JavaModuleDescriptor mainModuleDescriptor = request.getMainModuleDescriptor();
        HashMap<String, JavaModuleDescriptor> availableNamedModules = new HashMap<String, JavaModuleDescriptor>();
        HashMap<String, ResolvePathsResult.ModuleNameSource> moduleNameSources = new HashMap<String, ResolvePathsResult.ModuleNameSource>();
        result.setMainModuleDescriptor(mainModuleDescriptor);
        for (T t : request.getPathElements()) {
            Path path = request.toPath(t);
            File file = path.toFile();
            JavaModuleDescriptor moduleDescriptor = null;
            ResolvePathsResult.ModuleNameSource source = null;
            if (Files.isRegularFile(path, new LinkOption[0]) || Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
                moduleDescriptor = this.asmParser.getModuleDescriptor(path);
            }
            if (moduleDescriptor != null) {
                source = ResolvePathsResult.ModuleNameSource.MODULEDESCRIPTOR;
            } else {
                String moduleName = new ManifestModuleNameExtractor().extract(file);
                if (moduleName != null) {
                    source = ResolvePathsResult.ModuleNameSource.MANIFEST;
                } else {
                    moduleName = new JarModuleNameExtractor(request.getJdkHome()).extract(file);
                    if (moduleName != null) {
                        source = ResolvePathsResult.ModuleNameSource.FILENAME;
                    }
                }
                if (moduleName != null) {
                    moduleDescriptor = JavaModuleDescriptor.newAutomaticModule(moduleName).build();
                }
            }
            if (moduleDescriptor != null) {
                moduleNameSources.put(moduleDescriptor.name(), source);
                availableNamedModules.put(moduleDescriptor.name(), moduleDescriptor);
            }
            pathElements.put(t, moduleDescriptor);
        }
        result.setPathElements(pathElements);
        if (mainModuleDescriptor != null) {
            HashSet<String> requiredNamedModules = new HashSet<String>();
            requiredNamedModules.add(mainModuleDescriptor.name());
            this.select(mainModuleDescriptor, Collections.unmodifiableMap(availableNamedModules), requiredNamedModules);
            for (Map.Entry entry : pathElements.entrySet()) {
                if (entry.getValue() != null && requiredNamedModules.contains(((JavaModuleDescriptor)entry.getValue()).name())) {
                    result.getModulepathElements().put((T)entry.getKey(), (ResolvePathsResult.ModuleNameSource)((Object)moduleNameSources.get(((JavaModuleDescriptor)entry.getValue()).name())));
                    continue;
                }
                result.getClasspathElements().add(entry.getKey());
            }
        }
        return result;
    }

    private void select(JavaModuleDescriptor module, Map<String, JavaModuleDescriptor> availableModules, Set<String> namedModules) {
        for (JavaModuleDescriptor.JavaRequires requires : module.requires()) {
            String requiresName = requires.name();
            JavaModuleDescriptor requiredModule = availableModules.get(requiresName);
            if (requiredModule == null || !namedModules.add(requiresName)) continue;
            this.select(requiredModule, availableModules, namedModules);
        }
    }
}

