/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;

public class JarModuleNameExtractor
implements ModuleNameExtractor {
    private final File jdkHome;

    public JarModuleNameExtractor(File jdkHome) {
        this.jdkHome = jdkHome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String extract(File file) {
        try {
            File jsh = File.createTempFile("modulename_", ".jsh");
            jsh.deleteOnExit();
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("System.out.println(java.lang.module.ModuleFinder.of(java.nio.file.Paths.get(\"" + file.getAbsolutePath().replace("\\", "\\\\") + "\")).findAll().stream().findFirst().get().descriptor().name())");
            lines.add("/exit");
            Files.write(jsh.toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
            ProcessBuilder builder = new ProcessBuilder(new File(this.jdkHome, "bin/jshell").getAbsolutePath(), jsh.getAbsolutePath());
            Process p = builder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String string = reader.readLine();
                return string;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

