/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIOResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;

public class PlexusIoFileResourceCollection
extends AbstractPlexusIoResourceCollection
implements PlexusIOResourceCollectionWithAttributes {
    public static final String ROLE_HINT = "files";
    private File baseDir;
    private boolean isFollowingSymLinks = true;
    private FileAttributes overrideFileAttributes;
    private FileAttributes overrideDirAttributes;

    public PlexusIoFileResourceCollection() {
    }

    public PlexusIoFileResourceCollection(Logger logger) {
        super(logger);
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.overrideFileAttributes = new FileAttributes(gid, groupName, uid, userName, new char[0]);
        this.overrideFileAttributes.setOctalMode(fileMode);
        this.overrideDirAttributes = new FileAttributes(gid, groupName, uid, userName, new char[0]);
        this.overrideDirAttributes.setOctalMode(dirMode);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isFollowingSymLinks() {
        return this.isFollowingSymLinks;
    }

    public void setFollowingSymLinks(boolean pIsFollowingSymLinks) {
        this.isFollowingSymLinks = pIsFollowingSymLinks;
    }

    private void addResources(List list, String[] resources, Map attributesByPath) throws IOException {
        File dir = this.getBaseDir();
        for (int i = 0; i < resources.length; ++i) {
            String name = resources[i];
            String sourceDir = name.replace('\\', '/');
            File f = new File(dir, sourceDir);
            PlexusIoResourceAttributes attrs = (PlexusIoResourceAttributes)attributesByPath.get(f.getAbsolutePath());
            attrs = f.isDirectory() ? PlexusIoResourceAttributeUtils.mergeAttributes(this.overrideDirAttributes, attrs) : PlexusIoResourceAttributeUtils.mergeAttributes(this.overrideFileAttributes, attrs);
            PlexusIoFileResource resource = new PlexusIoFileResource(f, name, attrs);
            if (!this.isSelected(resource)) continue;
            list.add(resource);
        }
    }

    public Iterator getResources() throws IOException {
        String[] exc;
        DirectoryScanner ds = new DirectoryScanner();
        File dir = this.getBaseDir();
        ds.setBasedir(dir);
        String[] inc = this.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = this.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (this.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive());
        ds.setFollowSymlinks(this.isFollowingSymLinks());
        ds.scan();
        Map attributesByPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(this.getBaseDir());
        ArrayList result = new ArrayList();
        if (this.isIncludingEmptyDirectories()) {
            String[] dirs = ds.getIncludedDirectories();
            this.addResources(result, dirs, attributesByPath);
        }
        String[] files = ds.getIncludedFiles();
        this.addResources(result, files, attributesByPath);
        return result.iterator();
    }
}

