/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractCompilerTckTest
extends PlexusTestCase {
    private static final String EOL = System.getProperty("line.separator");
    private String roleHint;

    protected AbstractCompilerTckTest(String roleHint) {
        this.roleHint = roleHint;
    }

    public void testDeprecation() throws Exception {
        File foo = new File(this.getSrc(), "Foo.java");
        this.writeFileWithDeprecatedApi(foo, "Foo");
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setShowDeprecation(true);
        configuration.addSourceLocation(this.getSrc().getAbsolutePath());
        List result = this.compile(configuration);
        AbstractCompilerTckTest.assertEquals((int)1, (int)result.size());
        CompilerError error = (CompilerError)result.get(0);
        System.out.println(error.getMessage());
        AbstractCompilerTckTest.assertFalse((boolean)error.isError());
        AbstractCompilerTckTest.assertTrue((error.getMessage().indexOf("Date") != -1 ? 1 : 0) != 0);
        AbstractCompilerTckTest.assertTrue((error.getMessage().indexOf("deprecated") != -1 ? 1 : 0) != 0);
    }

    public void testWarning() throws Exception {
        File foo = new File(this.getSrc(), "Foo.java");
        this.writeFileWithWarning(foo, "Foo");
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setShowWarnings(true);
        configuration.addSourceLocation(this.getSrc().getAbsolutePath());
        List result = this.compile(configuration);
        AbstractCompilerTckTest.assertEquals((int)1, (int)result.size());
        CompilerError error = (CompilerError)result.get(0);
        AbstractCompilerTckTest.assertFalse((boolean)error.isError());
        AbstractCompilerTckTest.assertTrue((error.getMessage().indexOf("finally block does not complete normally") != -1 ? 1 : 0) != 0);
    }

    protected List compile(CompilerConfiguration configuration) throws Exception {
        File compilerOutput = this.getCompilerOutput();
        if (compilerOutput.exists()) {
            FileUtils.deleteDirectory((File)compilerOutput);
        }
        configuration.setOutputLocation(compilerOutput.getAbsolutePath());
        Compiler compiler = (Compiler)this.lookup(Compiler.ROLE, this.roleHint);
        List result = compiler.compile(configuration);
        AbstractCompilerTckTest.assertNotNull((Object)result);
        return result;
    }

    private File getCompilerOutput() {
        return AbstractCompilerTckTest.getTestFile((String)("target/compiler-output/" + this.getName()));
    }

    private File getSrc() {
        return AbstractCompilerTckTest.getTestFile((String)("target/compiler-src/" + this.getName()));
    }

    protected void writeFileWithDeprecatedApi(File path, String className) throws IOException {
        File parent = path.getParentFile();
        if (!parent.exists()) {
            AbstractCompilerTckTest.assertTrue((boolean)parent.mkdirs());
        }
        String source = "import java.util.Date;" + EOL + "" + EOL + "public class " + className + "" + EOL + "{" + EOL + "    private static Date date = new Date( \"foo\" );" + EOL + "    static " + EOL + "    { " + EOL + "        Date date = " + className + ".date; " + EOL + "        Date date2 = date; " + EOL + "        date = date2; " + EOL + "    }" + EOL + "}";
        FileUtils.fileWrite((String)path.getAbsolutePath(), (String)source);
    }

    protected void writeFileWithWarning(File path, String className) throws IOException {
        File parent = path.getParentFile();
        if (!parent.exists()) {
            AbstractCompilerTckTest.assertTrue((boolean)parent.mkdirs());
        }
        String source = "public class " + className + "" + EOL + "{" + EOL + "    public void foo()" + EOL + "    {" + EOL + "        try{ throw new java.io.IOException(); }" + EOL + "        finally { return; }" + EOL + "    }" + EOL + "}";
        FileUtils.fileWrite((String)path.getAbsolutePath(), (String)source);
    }
}

