/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SourceCodeLocator {
    private List sourceRoots;
    private Map cache;

    public SourceCodeLocator(List sourceRoots) {
        this.sourceRoots = sourceRoots;
        this.cache = new HashMap();
    }

    public File findSourceCodeForClass(String className) {
        File f = (File)this.cache.get(className);
        if (f != null) {
            return f;
        }
        String sourceName = className.replace('.', System.getProperty("file.separator").charAt(0));
        sourceName = sourceName + ".java";
        f = this.findInRoots(sourceName);
        this.cache.put(className, f);
        return f;
    }

    private File findInRoots(String s) {
        Iterator it = this.sourceRoots.iterator();
        while (it.hasNext()) {
            String root = (String)it.next();
            File f = new File(root, s);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }
}

