/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.csharp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

public class CSharpCompiler
extends AbstractCompiler {
    private final String ARGUMENTS_FILE_NAME = "csharp-arguments";

    public CSharpCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES, ".cs", null, null);
    }

    public boolean canUpdateTarget(CompilerConfiguration configuration) throws CompilerException {
        return false;
    }

    public String getOutputFile(CompilerConfiguration configuration) throws CompilerException {
        return configuration.getOutputFileName() + "." + this.getTypeExtension(configuration);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AbstractCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        System.out.println("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        String[] args = this.buildCompilerArguments(config, sourceFiles);
        if (!config.isFork()) {
            throw new CompilerException("This compiler doesn't support in-process compilation.");
        }
        List messages = this.compileOutOfProcess(config.getWorkingDirectory(), config.getBuildDirectory(), this.findExecutable(config), args);
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return this.buildCompilerArguments(config, AbstractCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    private String findExecutable(CompilerConfiguration config) {
        String executable = config.getExecutable();
        if (!StringUtils.isEmpty((String)executable)) {
            return executable;
        }
        if (Os.isFamily((String)"windows")) {
            return "csc";
        }
        return "mcs";
    }

    private String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) throws CompilerException {
        ArrayList<String> args = new ArrayList<String>();
        if (config.isDebug()) {
            args.add("/debug+");
        } else {
            args.add("/debug-");
        }
        Iterator it = config.getClasspathEntries().iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            File f = new File(element);
            if (!f.isFile()) continue;
            args.add("/reference:" + element);
        }
        LinkedHashMap compilerArguments = config.getCustomCompilerArguments();
        String mainClass = (String)compilerArguments.get("mainClass");
        if (!StringUtils.isEmpty((String)mainClass)) {
            args.add("/mainClass");
            args.add(mainClass);
        }
        args.add("/out:" + new File(config.getBuildDirectory(), this.getOutputFile(config)).getAbsolutePath());
        String target = (String)compilerArguments.get("target");
        if (StringUtils.isEmpty((String)target)) {
            args.add("/target:library");
        } else {
            args.add("/target:" + target);
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            String sourceFile = sourceFiles[i];
            args.add(sourceFile);
        }
        return args.toArray(new String[args.size()]);
    }

    private List compileOutOfProcess(File workingDirectory, File target, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        File file;
        PrintWriter output = null;
        try {
            file = new File(target, "csharp-arguments");
            output = new PrintWriter(new FileWriter(file));
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                System.out.println("arg: " + arg);
                output.println(arg);
            }
        }
        catch (IOException e) {
            try {
                throw new CompilerException("Error writing arguments file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close((Writer)output);
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cli.setExecutable(executable);
        cli.createArgument().setValue("@" + file.getAbsolutePath());
        StringWriter stringWriter = new StringWriter();
        WriterStreamConsumer out = new WriterStreamConsumer((Writer)stringWriter);
        WriterStreamConsumer err = new WriterStreamConsumer((Writer)stringWriter);
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = CSharpCompiler.parseCompilerOutput(new BufferedReader(new StringReader(((Object)stringWriter).toString())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing the compiler, but could not parse the error:" + AbstractCompiler.EOL + ((Object)stringWriter).toString(), true));
        }
        return messages;
    }

    public static List parseCompilerOutput(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> messages = new ArrayList<CompilerError>();
        String line = bufferedReader.readLine();
        while (line != null) {
            CompilerError compilerError = CSharpCompiler.parseLine(line);
            if (compilerError != null) {
                messages.add(compilerError);
            }
            line = bufferedReader.readLine();
        }
        return messages;
    }

    public static CompilerError parseLine(String line) {
        String message;
        String file = null;
        boolean error = true;
        int startline = -1;
        int startcolumn = -1;
        int endline = -1;
        int endcolumn = -1;
        String ERROR_PREFIX = "error ";
        String COMPILATION_PREFIX = "Compilation ";
        String MAGIC_LINE_MARKER = ".cs(";
        if (line.startsWith(ERROR_PREFIX)) {
            message = line.substring(ERROR_PREFIX.length());
        } else {
            if (line.startsWith(COMPILATION_PREFIX)) {
                return null;
            }
            if (line.indexOf(MAGIC_LINE_MARKER) != -1) {
                int i = line.indexOf(MAGIC_LINE_MARKER);
                int j = line.indexOf(32, i);
                file = line.substring(0, i + 3);
                String num = line.substring(i + MAGIC_LINE_MARKER.length(), j - 1);
                endline = startline = Integer.parseInt(num);
                message = line.substring(j + 1 + ERROR_PREFIX.length());
                error = line.indexOf(") error") != -1;
            } else {
                System.err.println("Unknown output: " + line);
                return null;
            }
        }
        return new CompilerError(file, error, startline, startcolumn, endline, endcolumn, message);
    }

    private String getType(Map compilerArguments) {
        String type = (String)compilerArguments.get("type");
        if (StringUtils.isEmpty((String)type)) {
            return "library";
        }
        return type;
    }

    private String getTypeExtension(CompilerConfiguration configuration) throws CompilerException {
        String type = this.getType(configuration.getCustomCompilerArguments());
        if (type.equals("exe") || type.equals("winexe")) {
            return "exe";
        }
        if (type.equals("library") || type.equals("module")) {
            return "dll";
        }
        throw new CompilerException("Unrecognized type '" + type + "'.");
    }
}

