/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.codehaus.plexus.components.io.functions.FileSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean isUptodate(PlexusIoResource source, File destination) {
        return ResourceUtils.isUptodate(source, destination.lastModified());
    }

    public static boolean isUptodate(PlexusIoResource source, long destinationDate) {
        return ResourceUtils.isUptodate(source.getLastModified(), destinationDate);
    }

    public static boolean isUptodate(long sourceDate, long destinationDate) {
        if (sourceDate == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate >= sourceDate;
    }

    public static void copyFile(PlexusIoResource in, File outFile) throws IOException {
        try (InputStream input = in.getContents();){
            Files.copy(input, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void copyFile(InputStream input, File outFile) throws IOException {
        Files.copy(input, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean isSame(PlexusIoResource resource, File file) {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)resource).getFile();
            return file.equals(resourceFile);
        }
        return false;
    }

    public static boolean isCanonicalizedSame(PlexusIoResource resource, File file) throws IOException {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)resource).getFile();
            return file.getCanonicalFile().equals(resourceFile.getCanonicalFile());
        }
        return false;
    }
}

