/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;

class JdkManifestFactory {
    JdkManifestFactory() {
    }

    public static Manifest getDefaultManifest() throws ArchiverException {
        InputStream in = null;
        String defManifest = "/org/codehaus/plexus/archiver/jar/defaultManifest.mf";
        try {
            in = JdkManifestFactory.class.getResourceAsStream("/org/codehaus/plexus/archiver/jar/defaultManifest.mf");
            if (in == null) {
                throw new ArchiverException("Could not find default manifest: /org/codehaus/plexus/archiver/jar/defaultManifest.mf");
            }
            Manifest defaultManifest = new Manifest(in);
            in.close();
            in = null;
            defaultManifest.getMainAttributes().putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            Manifest manifest = defaultManifest;
            return manifest;
        }
        catch (IOException e) {
            throw new ArchiverException("Unable to read default manifest", e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public static void merge(Manifest target, Manifest other, boolean overwriteMain) {
        if (other != null) {
            Attributes mainAttributes = target.getMainAttributes();
            if (overwriteMain) {
                mainAttributes.clear();
                mainAttributes.putAll((Map<?, ?>)other.getMainAttributes());
            } else {
                JdkManifestFactory.mergeAttributes(mainAttributes, other.getMainAttributes());
            }
            for (Map.Entry<String, Attributes> o : other.getEntries().entrySet()) {
                Attributes ourSection = target.getAttributes(o.getKey());
                Attributes otherSection = o.getValue();
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    target.getEntries().put(o.getKey(), (Attributes)otherSection.clone());
                    continue;
                }
                JdkManifestFactory.mergeAttributes(ourSection, otherSection);
            }
        }
    }

    public static void mergeAttributes(Attributes target, Attributes section) {
        for (Object o : section.keySet()) {
            Attributes.Name key = (Attributes.Name)o;
            Object value = section.get(o);
            target.put(key, value);
        }
    }
}

