/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";
    private Charset charset = Charset.forName("UTF-8");

    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{f.toURI().toURL()}, null){

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        ZipFile zipFile = new ZipFile(f, this.charset != null ? this.charset.name() : "UTF8");
        Enumeration en = zipFile.getEntriesInPhysicalOrder();
        return new ZipFileResourceIterator(en, url, zipFile, urlClassLoader);
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    private static class ZipFileResourceIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        private final Enumeration<ZipArchiveEntry> en;
        private final URL url;
        private final ZipFile zipFile;
        private final URLClassLoader urlClassLoader;

        public ZipFileResourceIterator(Enumeration<ZipArchiveEntry> en, URL url, ZipFile zipFile, URLClassLoader urlClassLoader) {
            this.en = en;
            this.url = url;
            this.zipFile = zipFile;
            this.urlClassLoader = urlClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry = this.en.nextElement();
            long l = entry.getTime();
            long lastModified = l == -1L ? 0L : l;
            boolean dir = entry.isDirectory();
            long size = dir ? -1L : entry.getSize();
            return new PlexusIoURLResource(entry.getName(), lastModified, size, !dir, dir, true){

                public URL getURL() throws IOException {
                    String spec = this.getName();
                    if (spec.startsWith("/")) {
                        spec = "./" + spec;
                        return new URL(ZipFileResourceIterator.this.url, spec);
                    }
                    return ZipFileResourceIterator.this.urlClassLoader.getResource(spec);
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

