/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webtest.components.Grep;
import org.codehaus.mojo.webtest.validation.FileContentValidationSet;
import org.codehaus.plexus.util.DirectoryScanner;

public class WebtestVerifyFileContentMojo
extends AbstractMojo {
    private FileContentValidationSet[] fileContentValidationSets;

    public FileContentValidationSet[] getFileContentValidationSets() {
        return this.fileContentValidationSets;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.fileContentValidationSets == null) {
                return;
            }
            for (int i = 0; i < this.getFileContentValidationSets().length; ++i) {
                FileContentValidationSet fileContentValidationSet = this.getFileContentValidationSets()[i];
                String regexp = fileContentValidationSet.getRegexp();
                this.getLog().info((CharSequence)("Searching for '" + regexp + "' ..."));
                File baseDir = fileContentValidationSet.getDir();
                DirectoryScanner ds = this.createDirectoryScanner(fileContentValidationSet);
                ds.scan();
                String[] includedFileNames = ds.getIncludedFiles();
                Grep grepper = new Grep(baseDir, includedFileNames, regexp);
                File[] fileList = grepper.match();
                if (fileList.length <= 0) continue;
                StringBuffer grepResult = new StringBuffer();
                grepResult.append("The regexp '");
                grepResult.append(regexp);
                grepResult.append("' was found in : ");
                for (int j = 0; j < fileList.length; ++j) {
                    grepResult.append(fileList[j]);
                    if (j >= fileList.length - 1) continue;
                    grepResult.append(";");
                }
                this.getLog().error((CharSequence)grepResult.toString());
                throw new MojoExecutionException(fileContentValidationSet.getMsg());
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to grep the files", e);
        }
    }

    private DirectoryScanner createDirectoryScanner(FileContentValidationSet fileContentValidationSet) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(fileContentValidationSet.getIncludes());
        ds.setExcludes(fileContentValidationSet.getExcludes());
        ds.setBasedir(fileContentValidationSet.getDir());
        ds.setCaseSensitive(false);
        return ds;
    }
}

