/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.commons.io.FileUtils;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.webtest.components.ReportCollector;
import org.codehaus.mojo.webtest.components.ResourceCopy;
import org.codehaus.mojo.webtest.components.XomHelper;
import org.codehaus.mojo.webtest.components.XslTransformer;

public class WebtestReportMojo
extends AbstractMavenReport {
    private static final String[] IMAGE_FILES = new String[]{"canoo.gif", "collapseall.png", "expandall.png", "expandMinus.png", "expandPlus.png", "favicon.ico", "failed.gif", "less.gif", "more.gif", "ok.gif", "optional.gif", "todo.gif", "webtest.jpg"};
    private static final String[] WEB_RESOURCE_FILES = new String[]{"report.css", "responseBrowser.html", "responseBrowser.js", "responseBrowserCommands.html", "responseBrowserPreviews.html", "showHide.js", "sorttable.js"};
    private Renderer siteRenderer;
    private MavenProject project;
    private File resultpath;
    private String reportoverviewxsl;
    private File reportdirectory;
    private String reportname;

    public String getName(Locale locale) {
        return "Canoo WebTest Report";
    }

    public String getDescription(Locale locale) {
        return "Canoo WebTest Report.";
    }

    protected String getOutputDirectory() {
        return this.reportdirectory.getAbsolutePath();
    }

    public String getOutputName() {
        return "webtest/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        try {
            ReportCollector walker = new ReportCollector("WebTestReport.xml");
            File[] currResultFileList = walker.run(this.resultpath);
            return currResultFileList.length > 0;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to search through the webtest result directories");
            return false;
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.createReportResources();
            this.createHtmlSingleTestReport();
            this.createXmlWebTestSummary();
            this.createXmlWebTestOverview();
            this.copyHtmlResponses();
            this.createHtmlWebTestOverview();
        }
        catch (Exception e) {
            String msg = "Generating the Canoo WebTest report failed";
            throw new MavenReportException(msg, e);
        }
    }

    private void createReportResources() throws Exception {
        ResourceCopy resourceCopy = new ResourceCopy();
        File reportResouceDirectory = new File(this.reportdirectory, "resources");
        File reportImageDirectory = new File(reportResouceDirectory, "images");
        resourceCopy.copy("/webtest/images/", IMAGE_FILES, reportImageDirectory);
        resourceCopy.copy("/webtest/resources/", WEB_RESOURCE_FILES, reportResouceDirectory);
    }

    private void createHtmlSingleTestReport() throws Exception {
        String xsltName = "WebTestReport.xsl";
        String xsltResourceName = "/webtest/xslt/" + xsltName;
        ReportCollector walker = new ReportCollector("WebTestReport.xml");
        File[] xmlReportList = walker.run(this.resultpath);
        Properties params = new Properties();
        params.setProperty("resources.dir", "../resources");
        params.setProperty("reporttime", new Date().toString());
        params.setProperty("title", this.project.getArtifactId());
        XslTransformer xslTransformer = new XslTransformer(this.getLog());
        for (File xmlReportFile : xmlReportList) {
            File xmlReportDirectory = xmlReportFile.getParentFile();
            File xmlResultFile = new File(xmlReportDirectory, "WebTestReport.html");
            StreamSource xslin = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(xsltResourceName));
            StreamSource xmlin = new StreamSource(new FileInputStream(xmlReportFile));
            StreamResult result = new StreamResult(new FileOutputStream(xmlResultFile));
            xslTransformer.transform(xsltName, xslin, xmlin, result, params);
        }
    }

    private void createXmlWebTestSummary() throws Exception {
        String xsltName = "WebTestReportSummaryExtractor.xsl";
        String xsltResourceName = "/webtest/xslt/" + xsltName;
        ReportCollector walker = new ReportCollector("WebTestReport.xml");
        File[] xmlReportList = walker.run(this.resultpath);
        XslTransformer xslTransformer = new XslTransformer(this.getLog());
        for (File xmlReportFile : xmlReportList) {
            File xmlReportDirectory = xmlReportFile.getParentFile();
            File xmlResultFile = new File(xmlReportDirectory, "WebTestSummary.xml");
            StreamSource xslin = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(xsltResourceName));
            StreamSource xmlin = new StreamSource(new FileInputStream(xmlReportFile));
            StreamResult result = new StreamResult(new FileOutputStream(xmlResultFile));
            xslTransformer.transform(xsltName, xslin, xmlin, result, null);
        }
    }

    private void createHtmlWebTestOverview() throws Exception {
        String xsltName = this.reportoverviewxsl;
        String xsltResourceName = "/webtest/xslt/" + xsltName;
        Properties params = new Properties();
        params.setProperty("resources.dir", "./resources");
        params.setProperty("reporttime", new Date().toString());
        params.setProperty("title", this.project.getArtifactId());
        File xmlInFile = new File(this.reportdirectory, "WebTestOverview.xml");
        File xmlResultFile = new File(this.reportdirectory, this.reportname);
        StreamSource xslin = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(xsltResourceName));
        StreamSource xmlin = new StreamSource(new FileInputStream(xmlInFile));
        StreamResult result = new StreamResult(new FileOutputStream(xmlResultFile));
        XslTransformer xslTransformer = new XslTransformer(this.getLog());
        xslTransformer.transform(xsltName, xslin, xmlin, result, params);
    }

    private void createXmlWebTestOverview() throws Exception {
        ReportCollector walker = new ReportCollector("WebTestSummary.xml");
        File[] xmlWebTestSummaryList = walker.run(this.resultpath);
        XomHelper xomHelper = new XomHelper();
        Document[] documentList = xomHelper.parse(xmlWebTestSummaryList);
        Element overview = new Element("overview");
        overview.addAttribute(new Attribute("Implementation-Title", "Canoo WebTest"));
        overview.addAttribute(new Attribute("Implementation-Version", "R_1810"));
        for (int i = 0; i < xmlWebTestSummaryList.length; ++i) {
            String currFolderName = xmlWebTestSummaryList[i].getParentFile().getName();
            Document currDocument = documentList[i];
            Element currFolder = new Element("folder");
            currFolder.addAttribute(new Attribute("name", currFolderName));
            xomHelper.appendDocument(currFolder, currDocument);
            overview.appendChild((Node)currFolder);
        }
        Document document = new Document(overview);
        xomHelper.toFile(document, new File(this.reportdirectory, "WebTestOverview.xml"));
    }

    private void copyHtmlResponses() throws Exception {
        FileUtils.copyDirectory((File)this.resultpath, (File)this.reportdirectory);
    }
}

