/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webtest.AbstractWebtestMojo;
import org.codehaus.mojo.webtest.components.AntExecutor;

public class WebtestLoopMojo
extends AbstractWebtestMojo {
    private int loops;

    public void execute() throws MojoExecutionException {
        File webtestFile = new File(this.getSourcedirectory(), this.getSourcefile());
        try {
            this.getLog().info((CharSequence)("Executing " + webtestFile.getAbsolutePath()));
            Properties userProperties = this.toProperties();
            userProperties.setProperty("haltonerror", "true");
            userProperties.setProperty("haltonfailure", "true");
            long startTime = System.currentTimeMillis();
            for (int i = 1; i <= this.loops; ++i) {
                long loopStartTime = System.currentTimeMillis();
                new AntExecutor(webtestFile, userProperties, this.getProject(), this.getArtifacts(), this.getTarget());
                long currentTimeMillis = System.currentTimeMillis();
                long loopDuration = currentTimeMillis - loopStartTime;
                long duration = currentTimeMillis - startTime;
                String msg = "Finshed " + i + "/" + this.loops + " iterations in " + loopDuration + "/" + duration + " ms";
                this.getLog().info((CharSequence)msg);
            }
        }
        catch (Exception e) {
            String msg = "Executing " + webtestFile.getAbsolutePath() + " failed";
            throw new MojoExecutionException(msg, e);
        }
    }
}

