/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webtest;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWebtestMojo
extends AbstractMojo {
    private MavenProject project;
    private List artifacts;
    private boolean autorefresh;
    private String basepath;
    private String failureproperty;
    private boolean haltonerror;
    private boolean haltonfailure;
    private String host;
    private String loglevel;
    private String port;
    private String protocol;
    private File reportdirectory;
    private String reportname;
    private File resultpath;
    private String resultreporterclass;
    private String saveprefix;
    private boolean saveresponse;
    private File sourcedirectory;
    private String sourcefile;
    private String target;
    private int timeout;
    private String propertyprefix = "";

    public MavenProject getProject() {
        return this.project;
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public boolean isAutorefresh() {
        return this.autorefresh;
    }

    public String getBasepath() {
        return this.basepath != null ? this.basepath : "";
    }

    public String getFailureproperty() {
        return this.failureproperty;
    }

    public boolean isHaltonerror() {
        return this.haltonerror;
    }

    public boolean isHaltonfailure() {
        return this.haltonfailure;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public File getResultpath() {
        return this.resultpath;
    }

    public String getReportname() {
        return this.reportname;
    }

    public String getResultReporterClass() {
        return this.resultreporterclass;
    }

    public boolean isSaveResponse() {
        return this.saveresponse;
    }

    public String getSaveprefix() {
        return this.saveprefix;
    }

    public File getSourcedirectory() {
        return this.sourcedirectory;
    }

    public String getSourcefile() {
        return this.sourcefile;
    }

    public String getTarget() {
        return this.target;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public File getReportdirectory() {
        return this.reportdirectory;
    }

    public String getSourceUrl() {
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.getBasepath();
    }

    public String getLoglevel() {
        return this.loglevel;
    }

    public String getPropertyPrefix() {
        return this.propertyprefix;
    }

    protected Properties toProperties() {
        NullSafeProperties result = new NullSafeProperties();
        Properties mavenProps = this.project.getProperties();
        for (String string : mavenProps.keySet()) {
            result.setProperty(this.propertyprefix + string, mavenProps.getProperty(string));
        }
        result.setProperty(this.propertyprefix, "project.groupId", this.project.getGroupId());
        result.setProperty(this.propertyprefix, "project.artifactId", this.project.getArtifactId());
        result.setProperty(this.propertyprefix, "project.name", this.project.getName());
        result.setProperty(this.propertyprefix, "project.description", this.project.getDescription());
        result.setProperty(this.propertyprefix, "project.version", this.project.getVersion());
        result.setProperty(this.propertyprefix, "project.packaging", this.project.getPackaging());
        result.setProperty(this.propertyprefix, "project.build.directory", this.project.getBuild().getDirectory());
        result.setProperty(this.propertyprefix, "project.build.outputDirectory", this.project.getBuild().getOutputDirectory());
        result.setProperty(this.propertyprefix, "project.build.outputTestDirectory", this.project.getBuild().getTestOutputDirectory());
        result.setProperty(this.propertyprefix, "project.build.sourceDirectory", this.project.getBuild().getSourceDirectory());
        result.setProperty(this.propertyprefix, "project.build.testSourceDirectory", this.project.getBuild().getTestSourceDirectory());
        result.setProperty(this.propertyprefix, "project.build.finalName", this.project.getBuild().getFinalName());
        result.setProperty("autorefresh", Boolean.toString(this.isAutorefresh()));
        result.setProperty("basepath", this.getBasepath());
        result.setProperty("haltonerror", Boolean.toString(this.isHaltonerror()));
        result.setProperty("haltonfailure", Boolean.toString(this.isHaltonfailure()));
        result.setProperty("host", this.getHost());
        result.setProperty("port", this.getPort());
        result.setProperty("protocol", this.getProtocol());
        result.setProperty("resultpath", this.getResultpath().getAbsolutePath());
        result.setProperty("saveresponse", Boolean.toString(this.isSaveResponse()));
        result.setProperty("summary", "true");
        result.setProperty("timeout", Integer.toString(this.getTimeout()));
        result.setProperty("webtest.resultreporterclass", this.getResultReporterClass());
        System.setProperty("logLevel.webtest", this.getLoglevel());
        System.setProperty("logLevel.htmlunit", this.getLoglevel());
        System.setProperty("logLevel.httpclientWire", this.getLoglevel());
        return result;
    }

    private class NullSafeProperties
    extends Properties {
        private NullSafeProperties() {
        }

        public Object setProperty(String key, String value) {
            if (key != null && value != null) {
                return super.setProperty(key, value);
            }
            return null;
        }

        public Object setProperty(String prefix, String key, String value) {
            String currKey = (prefix != null ? prefix : "") + key.toString();
            return this.setProperty(currKey, value);
        }
    }
}

