/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.util;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.List;
import org.apache.log4j.Logger;

public class FormUtil {
    private static final Logger LOG = Logger.getLogger(FormUtil.class);

    private static boolean hasField(HtmlForm form, String tag, String type, String name) {
        List elements = form.getHtmlElementsByTagName(tag);
        for (HtmlElement element : elements) {
            if (!name.equals(element.getAttribute("name")) || type != null && !type.equalsIgnoreCase(element.getAttribute("type"))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTextField(HtmlForm form, String name) {
        if (FormUtil.hasTextAreaField(form, name)) {
            return true;
        }
        return FormUtil.hasTextOrPasswordField(form, name);
    }

    private static boolean hasTextOrPasswordField(HtmlForm form, String name) {
        List li = form.getInputsByName(name);
        for (HtmlInput element : li) {
            if (!"text".equalsIgnoreCase(element.getTypeAttribute()) && !"password".equalsIgnoreCase(element.getTypeAttribute())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTextAreaField(HtmlForm form, String name) {
        return !form.getTextAreasByName(name).isEmpty();
    }

    public static HtmlForm findFormForField(Context context, String givenFormName, String tag, String type, String name, Step step) {
        LOG.debug((Object)("Looking for form with " + tag + " field " + type + " named \"" + name + "\""));
        HtmlForm form = null;
        if (givenFormName != null) {
            HtmlForm givenForm = FormUtil.findFormByName(context.getCurrentHtmlResponse(step), givenFormName);
            form = FormUtil.checkFormIsSuitable(givenForm, tag, type, name);
        }
        if (form != null) {
            return form;
        }
        LOG.debug((Object)"No given form or given form not suitable, trying others");
        form = FormUtil.checkFormIsSuitable(context.getCurrentForm(), tag, type, name);
        if (form != null) {
            return form;
        }
        LOG.debug((Object)"No current form or current form not suitable, trying others");
        return FormUtil.searchAllFormsForSuitableOne(context, tag, type, name, step);
    }

    private static HtmlForm checkFormIsSuitable(HtmlForm candidateForm, String tag, String type, String name) {
        if (candidateForm != null && FormUtil.hasField(candidateForm, tag, type, name)) {
            LOG.debug((Object)("Form '" + candidateForm.getNameAttribute() + "' has suitable field, using it"));
            return candidateForm;
        }
        return null;
    }

    private static HtmlForm searchAllFormsForSuitableOne(Context context, String tag, String type, String name, Step step) {
        for (HtmlForm curForm : context.getCurrentHtmlResponse(step).getForms()) {
            if (!FormUtil.hasField(curForm, tag, type, name)) continue;
            context.setCurrentForm(curForm);
            return curForm;
        }
        return null;
    }

    public static HtmlForm findFormForTextField(Context context, String givenFormName, String name, Step step) {
        LOG.debug((Object)("Looking for form with text field named \"" + name + "\""));
        HtmlForm form = null;
        if (givenFormName != null) {
            HtmlForm givenForm = FormUtil.findFormByName(context.getCurrentHtmlResponse(step), givenFormName);
            form = FormUtil.checkFormIsSuitable(givenForm, name);
        }
        if (form != null) {
            return form;
        }
        LOG.debug((Object)"No given form or given form not suitable, trying others");
        form = FormUtil.checkFormIsSuitable(context.getCurrentForm(), name);
        if (form != null) {
            return form;
        }
        LOG.debug((Object)"No current form or current form not suitable, trying others");
        return FormUtil.searchAllFormsForSuitableOne(context, name, step);
    }

    private static HtmlForm checkFormIsSuitable(HtmlForm candidateForm, String name) {
        if (candidateForm != null && FormUtil.hasTextField(candidateForm, name)) {
            LOG.debug((Object)("Form '" + candidateForm.getNameAttribute() + "' has suitable text field, using it"));
            return candidateForm;
        }
        return null;
    }

    private static HtmlForm searchAllFormsForSuitableOne(Context context, String name, Step step) {
        for (HtmlForm curForm : context.getCurrentHtmlResponse(step).getForms()) {
            if (!FormUtil.hasTextField(curForm, name)) continue;
            context.setCurrentForm(curForm);
            return curForm;
        }
        return null;
    }

    public static HtmlForm findFormByName(HtmlPage currentResp, String name) {
        LOG.debug((Object)("Looking for form named '" + name + "'"));
        try {
            return currentResp.getFormByName(name);
        }
        catch (Exception e) {
            LOG.debug((Object)("Exception: " + e.getMessage()));
            return null;
        }
    }

    public static HtmlForm findFormByIndex(HtmlPage currentResp, String indexStr) {
        LOG.debug((Object)("Looking for form with index '" + indexStr + "'"));
        int index = ConversionUtil.convertToInt(indexStr, 0);
        int numForms = currentResp.getForms().size();
        if (index >= numForms) {
            LOG.info((Object)("Index value of '" + index + "' not in expected range: 0.." + (numForms - 1)));
            return null;
        }
        return (HtmlForm)currentResp.getForms().get(index);
    }
}

