/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.steps.request.AbstractTargetAction;
import com.canoo.webtest.util.FileUtil;
import com.canoo.webtest.util.MapUtil;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class InvokePage
extends AbstractTargetAction {
    private String fUrl;
    private String fCompleteUrl;
    private String fMethod = "GET";
    private File fContentFile;
    private String fContent;
    private String fSoapAction;

    public String getMethod() {
        return this.fMethod;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public void addText(String txt) {
        String expandedText = this.getProject().replaceProperties(txt);
        if (this.getUrl() == null) {
            this.setUrl(expandedText);
        } else {
            this.setContent(expandedText);
        }
    }

    public void setUrl(String newUrl) {
        this.fUrl = newUrl;
    }

    public void setMethod(String method) {
        this.fMethod = method;
    }

    public File getContentFile() {
        return this.fContentFile;
    }

    public void setContentFile(File contentFile) {
        this.fContentFile = contentFile;
    }

    public String getContent() {
        return this.fContent;
    }

    public void setContent(String content) {
        this.fContent = content;
    }

    public String getSoapAction() {
        return this.fSoapAction;
    }

    public void setSoapAction(String soapAction) {
        this.fSoapAction = soapAction;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getUrl(), "url");
        this.paramCheck(this.getContent() != null && this.getContentFile() != null, "Only one of 'content' and 'contentFile' must be set.");
        this.paramCheck("POST".equals(this.getMethod()) && this.getContent() == null && this.getContentFile() == null, "One of 'content' or 'contentFile' must be set for POST.");
    }

    protected Page findTarget() throws IOException, SAXException {
        if ("POST".equals(this.getMethod())) {
            return this.findTargetByPost();
        }
        this.fCompleteUrl = this.getContext().getConfig().getUrlForPage(this.getUrl());
        WebRequest settings = new WebRequest(new URL(this.fCompleteUrl));
        settings.setHttpMethod(HttpMethod.valueOf((String)this.getMethod().toUpperCase()));
        return this.getResponse(settings);
    }

    private Page findTargetByPost() throws IOException, SAXException {
        String url = this.getContext().getConfig().getUrlForPage(this.getUrl());
        WebRequest settings = new WebRequest(new URL(url), HttpMethod.POST);
        String charset = System.getProperty("file.encoding");
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)this.fSoapAction)) {
            headers.put("Content-type", "text/xml; charset=" + charset);
            headers.put("SOAPAction", this.fSoapAction);
        } else {
            headers.put("Content-type", "application/x-www-form-urlencoded");
        }
        settings.setAdditionalHeaders(headers);
        String content = this.getContent() != null ? this.getContent() : FileUtil.readFileToString(this.getContentFile(), this);
        settings.setRequestBody(content);
        settings.setCharset(charset);
        return this.getResponse(settings);
    }

    protected String getLogMessageForTarget() {
        return "by URL: " + this.getUrl();
    }

    protected void addComputedParameters(Map map) {
        super.addComputedParameters(map);
        if (!StringUtils.equals((String)this.fUrl, (String)this.fCompleteUrl)) {
            MapUtil.putIfNotNull(map, "-> complete url", this.fCompleteUrl);
        }
    }
}

