/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.security;

import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.interfaces.IConnectionInitializer;
import com.canoo.webtest.security.ConnectionInitializationException;
import com.canoo.webtest.security.SecurityConstants;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;

public abstract class AbstractConnectionInitializer
extends SecurityConstants
implements IConnectionInitializer {
    private static final Logger LOG = Logger.getLogger(AbstractConnectionInitializer.class);
    protected static final String SUN_JSSE_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    protected static final String SUN_SSL_PROTOCOL_HANDLER_PACKAGE = "com.sun.net.ssl.internal.www.protocol";
    protected static final String PROTOCOL_HANDLER_KEY = "java.protocol.handler.pkgs";
    protected static final String TRUST_STORE_KEY = "javax.net.ssl.trustStore";
    protected static final String TRUST_STORE_PASSWORD_KEY = "javax.net.ssl.trustStorePassword";

    public static String getExternalProperty(Configuration config, String propertyName) {
        return config.getExternalProperty(propertyName);
    }

    protected static void logProperty(Configuration config, String propertyName) {
        LOG.debug((Object)("Ext property: " + propertyName + "=" + AbstractConnectionInitializer.getExternalProperty(config, propertyName)));
    }

    public static boolean isProtocolHttps(Configuration config) {
        return "https".equals(config.getProtocol());
    }

    protected static boolean hasProvider(Class providerClass) {
        LOG.debug((Object)("Looking for provider class " + providerClass));
        Provider[] list = Security.getProviders();
        for (int i = 0; i < list.length; ++i) {
            Provider provider = list[i];
            LOG.debug((Object)("Checking: " + AbstractConnectionInitializer.providerInfoString(provider)));
            if (!provider.getClass().equals(providerClass)) continue;
            return true;
        }
        return false;
    }

    static void logSecurityProviders() {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LOG.info((Object)("Security Provider " + i + ": " + AbstractConnectionInitializer.providerInfoString(providers[i])));
        }
    }

    private static String providerInfoString(Provider provider) {
        StringBuffer sb = new StringBuffer();
        sb.append(provider.getName());
        sb.append("\n\t").append(provider.getInfo());
        sb.append("\n\t").append(provider.getClass().getName());
        sb.append("\n\tversion: ").append(provider.getVersion());
        return sb.toString();
    }

    protected static void installJsseProviderIfRequired(String providerClassName) throws ConnectionInitializationException {
        Class<?> providerClass;
        try {
            providerClass = Class.forName(providerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionInitializationException("Class " + providerClassName + "not found! Is JSSE correctly installed?");
        }
        if (!AbstractConnectionInitializer.hasProvider(providerClass)) {
            try {
                LOG.info((Object)(providerClassName + " not present. Current Providers are:"));
                AbstractConnectionInitializer.logSecurityProviders();
                Security.addProvider((Provider)providerClass.newInstance());
                LOG.info((Object)(providerClassName + " added. Providers are now:"));
                AbstractConnectionInitializer.logSecurityProviders();
            }
            catch (Exception e) {
                String message = "Can not instantiate class " + providerClassName + "!";
                LOG.info((Object)message, (Throwable)e);
                throw new ConnectionInitializationException(message);
            }
        }
    }

    protected static void setSystemProperty(String key, String value) {
        LOG.debug((Object)("Set " + key + " to " + value + ", was " + System.setProperty(key, value)));
    }
}

