/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.plugins.emailtest.AbstractSelectStep;
import com.canoo.webtest.util.ConversionUtil;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmailStoreMessageId
extends AbstractSelectStep {
    private static final Logger LOG = Logger.getLogger(EmailStoreMessageId.class);
    private String fMessageIndex;

    public String getMessageIndex() {
        return this.fMessageIndex;
    }

    public void setMessageIndex(String index) {
        this.fMessageIndex = index;
    }

    protected String processContent(Folder folder) throws MessagingException {
        Message[] messages = this.retrieveMatchingMessages(folder);
        if (StringUtils.isEmpty((String)this.fMessageIndex)) {
            LOG.info((Object)"Multiple matching messages found, using the first.");
        }
        if (messages.length == 0) {
            throw new MessagingException("No messages matching criteria.");
        }
        int messageIndex = ConversionUtil.convertToInt(this.getMessageIndex(), 0);
        if (messageIndex >= messages.length) {
            throw new MessagingException("Invalid messageIndex '" + this.getMessageIndex() + "', valid range is 0.." + (messages.length - 1));
        }
        return String.valueOf(messages[messageIndex].getMessageNumber());
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.getMessageIndex(), "messageIndex", true);
    }
}

