/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.emailtest.AbstractBaseStep;
import com.canoo.webtest.plugins.emailtest.EmailConfigInfo;
import com.canoo.webtest.plugins.emailtest.ISingleMessageStep;
import com.canoo.webtest.util.ConversionUtil;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

public abstract class AbstractMessageOperationStep
extends AbstractBaseStep
implements ISingleMessageStep {
    private String fMessageId;
    private boolean fDeleteOnExit;

    protected AbstractMessageOperationStep(boolean deleteOnExit) {
        this.fDeleteOnExit = deleteOnExit;
    }

    public String getMessageId() {
        return this.fMessageId;
    }

    public void setMessageId(String id) {
        this.fMessageId = id;
    }

    protected abstract void performOperation(Message var1) throws MessagingException;

    public void doExecute() throws Exception {
        EmailConfigInfo configInfo = (EmailConfigInfo)this.getContext().get("EmailConfigInfo");
        Folder folder = null;
        try {
            folder = this.getHelper().getInboxFolder(configInfo);
            int id = ConversionUtil.convertToInt(this.getMessageId(), 0);
            Message message = this.getHelper().getMessage(id, folder);
            if (message == null) {
                throw new StepFailedException("Could not retrieve message.", this);
            }
            this.performOperation(message);
        }
        catch (MessagingException e) {
            throw new StepFailedException("Error performing operation: " + e.getMessage(), this);
        }
        finally {
            this.getHelper().logout(folder, this.fDeleteOnExit);
        }
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.integerParamCheck(this.fMessageId, "messageId", true);
    }
}

