/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.extension.VerifyContentDiff;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;

public class VerifyContentBinDiff
implements VerifyContentDiff {
    public String compare(WebResponse reference, WebResponse actual, String referenceLabel, String actualLabel) {
        byte[] refBytes;
        byte[] actualBytes;
        if (this.sameContent(reference, actual)) {
            return null;
        }
        try {
            actualBytes = IOUtils.toByteArray((InputStream)actual.getContentAsStream());
            refBytes = IOUtils.toByteArray((InputStream)reference.getContentAsStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.produceBinDiffMessage(actualBytes, refBytes);
    }

    private boolean sameContent(WebResponse reference, WebResponse actual) {
        try {
            return IOUtils.contentEquals((InputStream)reference.getContentAsStream(), (InputStream)actual.getContentAsStream());
        }
        catch (IOException e) {
            throw new StepExecutionException("Error reading content", e);
        }
    }

    protected String produceBinDiffMessage(byte[] actualBytes, byte[] referenceBytes) {
        String msg;
        byte[] longerArray;
        int extractLength = 10;
        int minLength = Math.min(actualBytes.length, referenceBytes.length);
        for (int i = 0; i < minLength; ++i) {
            if (actualBytes[i] == referenceBytes[i]) continue;
            byte[] extract1 = ArrayUtils.subarray((byte[])actualBytes, (int)i, (int)(i + 10));
            byte[] extract2 = ArrayUtils.subarray((byte[])referenceBytes, (int)i, (int)(i + 10));
            return "First difference at position " + (i + 1) + ": " + String.valueOf(Hex.encodeHex((byte[])extract1)) + " <> " + String.valueOf(Hex.encodeHex((byte[])extract2));
        }
        if (actualBytes.length < referenceBytes.length) {
            longerArray = referenceBytes;
            msg = "Reference binary content starts with actual binary content";
        } else {
            longerArray = actualBytes;
            msg = "Actual binary content starts with reference binary content";
        }
        byte[] startOfLonger = ArrayUtils.subarray((byte[])longerArray, (int)minLength, (int)(minLength + 10));
        return msg + ". Longer content continues with: " + String.valueOf(Hex.encodeHex((byte[])startOfLonger));
    }
}

