/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.AbstractFilter;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class NormalizeXmlFilter
extends AbstractFilter {
    private static final Logger LOG = Logger.getLogger(NormalizeXmlFilter.class);

    public void doExecute() throws Exception {
        Page currentResponse = this.getContext().getCurrentResponse();
        if (currentResponse instanceof XmlPage) {
            Document doc = ((XmlPage)currentResponse).getXmlDocument();
            doc.getDocumentElement();
            this.processXml(doc, currentResponse.getWebResponse().getContentType());
        } else if (currentResponse instanceof HtmlPage) {
            this.processXml((Document)((HtmlPage)currentResponse), "text/xml");
        } else {
            throw new StepFailedException("Current response is not XML or HTML but: " + currentResponse.getClass().getSimpleName() + " " + currentResponse.getWebResponse().getContentType());
        }
    }

    private void processXml(Document doc, String contentType) throws Exception {
        this.defineAsCurrentResponse(NormalizeXmlFilter.serializeXml(doc), contentType);
    }

    private static String serializeXml(Document rootDoc) throws IOException {
        StringBuffer buf = new StringBuffer();
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)writer, NormalizeXmlFilter.buildFormatter(rootDoc));
        serializer.serialize(rootDoc);
        buf.append(((Object)writer).toString());
        return buf.toString();
    }

    private static OutputFormat buildFormatter(Document doc) {
        OutputFormat format = new OutputFormat(doc);
        format.setIndenting(true);
        format.setIndent(2);
        return format;
    }
}

