/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.ant;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CountWebtestResults
extends Task {
    private boolean failOnError = true;
    private String failureProperty;
    private String successProperty;
    private int nbSuccessful = 0;
    private int nbFailed = 0;
    private File fResultFile;

    public void execute() throws BuildException {
        this.readResults();
        this.setProperties();
        int nbTests = this.nbFailed + this.nbSuccessful;
        if (this.failOnError && this.nbFailed != 0) {
            throw new BuildException(this.nbFailed + " of " + nbTests + " webtests have failed (" + this.nbSuccessful + " successful)!");
        }
        this.log(nbTests + " webtests run (successful: " + this.nbSuccessful + ", failed: " + this.nbFailed + ")", 1);
    }

    void setProperties() {
        if (!StringUtils.isEmpty((String)this.failureProperty) && this.getNbFailed() != 0) {
            this.getProject().setNewProperty(this.failureProperty, String.valueOf(this.getNbFailed()));
        }
        if (!StringUtils.isEmpty((String)this.successProperty) && this.getNbSuccessful() != 0) {
            this.getProject().setNewProperty(this.successProperty, String.valueOf(this.getNbSuccessful()));
        }
    }

    void readResults() {
        SAXParser saxParser;
        if (this.fResultFile == null) {
            throw new BuildException("Mandatory attribute >resultFile< not set!");
        }
        if (!this.fResultFile.exists()) {
            throw new BuildException("Can't find result file >" + this.fResultFile.getAbsolutePath() + "<");
        }
        WebTestResultCounter counter = new WebTestResultCounter();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            saxParser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new BuildException("Failed to create SAX parser", (Throwable)e);
        }
        try {
            saxParser.parse(this.fResultFile, (DefaultHandler)counter);
        }
        catch (Exception e) {
            throw new BuildException("Failed to parse result file >" + this.fResultFile + "<", (Throwable)e);
        }
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean _failOnError) {
        this.failOnError = _failOnError;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String _failuresProperty) {
        this.failureProperty = _failuresProperty;
    }

    public String getSuccessProperty() {
        return this.successProperty;
    }

    public void setSuccessProperty(String _successProperty) {
        this.successProperty = _successProperty;
    }

    public File getResultFile() {
        return this.fResultFile;
    }

    public void setResultFile(File _resultFile) {
        this.fResultFile = _resultFile;
    }

    protected int getNbSuccessful() {
        return this.nbSuccessful;
    }

    protected int getNbFailed() {
        return this.nbFailed;
    }

    private class WebTestResultCounter
    extends DefaultHandler {
        private WebTestResultCounter() {
        }

        public void startElement(String _uri, String _localName, String _name, Attributes _attributes) throws SAXException {
            if ("summary".equals(_name)) {
                boolean success = "yes".equals(_attributes.getValue("successful"));
                if (success) {
                    ++CountWebtestResults.this.nbSuccessful;
                } else {
                    ++CountWebtestResults.this.nbFailed;
                }
            }
        }
    }
}

