/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.sign;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.webstart.sign.SignConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=SignTool.class, hint="default")
public class DefaultSignTool
extends AbstractLogEnabled
implements SignTool {
    @Requirement
    private JarSigner jarSigner;
    @Requirement
    private KeyTool keyTool;
    @Requirement
    protected IOUtil ioUtil;

    @Override
    public void generateKey(SignConfig config, File keystoreFile) throws MojoExecutionException {
        KeyToolGenerateKeyPairRequest request = config.createKeyGenRequest(keystoreFile);
        try {
            JavaToolResult result = this.keyTool.execute((JavaToolRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not generate key store " + keystoreFile, (Exception)exception);
            }
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                throw new MojoExecutionException("Could not generate key store " + keystoreFile + ", use -X to have detail of error");
            }
        }
        catch (JavaToolException e) {
            throw new MojoExecutionException("Could not find keytool", (Exception)((Object)e));
        }
    }

    @Override
    public void sign(SignConfig config, File jarFile, File signedJar) throws MojoExecutionException {
        JarSignerRequest request = config.createSignRequest(jarFile, signedJar);
        try {
            JavaToolResult result = this.jarSigner.execute((JavaToolRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not sign jar " + jarFile, (Exception)exception);
            }
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                throw new MojoExecutionException("Could not sign jar " + jarFile + ", use -X to have detail of error");
            }
        }
        catch (JavaToolException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    @Override
    public void verify(SignConfig config, File jarFile, boolean certs) throws MojoExecutionException {
        JarSignerRequest request = config.createVerifyRequest(jarFile, certs);
        try {
            JavaToolResult result = this.jarSigner.execute((JavaToolRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not verify jar " + jarFile, (Exception)exception);
            }
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                throw new MojoExecutionException("Could not verify jar " + jarFile + ", use -X to have detail of error");
            }
        }
        catch (JavaToolException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    @Override
    public boolean isJarSigned(File jarFile) throws MojoExecutionException {
        try {
            return JarSignerUtil.isArchiveSigned((File)jarFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not verifiy that jar is signed or not", (Exception)e);
        }
    }

    @Override
    public void unsign(File jarFile, boolean verbose) throws MojoExecutionException {
        if (this.isJarSigned(jarFile)) {
            this.verboseLog(verbose, "Unsign jar " + jarFile);
            try {
                JarSignerUtil.unsignArchive((File)jarFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not find unsign jar " + jarFile, (Exception)e);
            }
        } else {
            this.verboseLog(verbose, "Jar " + jarFile + " is not signed.");
        }
    }

    @Override
    public void deleteKeyStore(File keystore, boolean verbose) {
        if (keystore.exists()) {
            if (keystore.delete()) {
                this.infoOrDebug(verbose, "deleted keystore from: " + keystore.getAbsolutePath());
            } else {
                this.getLogger().warn("Couldn't delete keystore from: " + keystore.getAbsolutePath());
            }
        } else {
            this.infoOrDebug(verbose, "Skipping deletion of non existing keystore: " + keystore.getAbsolutePath());
        }
    }

    @Override
    public File getKeyStoreFile(String keystore, File workingKeystore, ClassLoader classLoader) throws MojoExecutionException {
        File result;
        URI keystoreURI = null;
        try {
            keystoreURI = URI.create(keystore);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (keystoreURI == null || keystoreURI.getScheme() == null) {
            result = new File(keystore);
        } else {
            result = workingKeystore;
            this.ioUtil.makeDirectoryIfNecessary(result.getParentFile());
            this.ioUtil.copyResources(keystoreURI, classLoader, result);
        }
        return result;
    }

    protected void verboseLog(boolean verbose, String msg) {
        this.infoOrDebug(verbose || this.getLogger().isInfoEnabled(), msg);
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLogger().info(msg);
        } else {
            this.getLogger().debug(msg);
        }
    }
}

