/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.BooleanUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.codehaus.mojo.webstart.generator.GeneratorExtraConfig;
import org.codehaus.mojo.webstart.generator.GeneratorTechnicalConfig;
import org.codehaus.plexus.util.WriterFactory;

public abstract class AbstractGenerator<C extends GeneratorExtraConfig> {
    private VelocityEngine engine;
    private Template velocityTemplate;
    private final GeneratorTechnicalConfig config;
    private final C extraConfig;
    private Log log;
    public static final String EOL = System.getProperty("line.separator");

    protected AbstractGenerator(Log log, GeneratorTechnicalConfig config, C extraConfig) {
        this.log = log;
        this.config = config;
        this.extraConfig = extraConfig;
        Properties props = new Properties();
        String inputFileTemplatePath = config.getInputFileTemplatePath();
        if (inputFileTemplatePath != null) {
            props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            props.setProperty("file.resource.loader.path", config.getResourceLoaderPath().getAbsolutePath());
            this.initVelocity(props);
            if (!this.engine.templateExists(inputFileTemplatePath)) {
                log.warn((CharSequence)"Warning, template not found. Will probably fail.");
            }
        } else {
            log.info((CharSequence)"No template specified Using default one.");
            inputFileTemplatePath = config.getDefaultTemplateResourceName();
            String webstartJarURL = config.getWebstartJarURL();
            log.debug((CharSequence)("***** Webstart JAR URL: " + webstartJarURL));
            props = new Properties();
            props.setProperty("resource.loader", "jar");
            props.setProperty("jar.resource.loader.description", "Jar resource loader for default webstart templates");
            props.setProperty("jar.resource.loader.class", "org.apache.velocity.runtime.resource.loader.JarResourceLoader");
            props.setProperty("jar.resource.loader.path", webstartJarURL);
            this.initVelocity(props);
            if (!this.engine.templateExists(inputFileTemplatePath)) {
                log.error((CharSequence)("Inbuilt template not found!! " + config.getDefaultTemplateResourceName() + " Will probably fail."));
            }
        }
        try {
            this.velocityTemplate = this.engine.getTemplate(inputFileTemplatePath, config.getEncoding());
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not load the template file from '" + inputFileTemplatePath + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    private void initVelocity(Properties props) {
        try {
            this.engine = new VelocityEngine();
            this.engine.setProperty("runtime.log.logsystem", (Object)new NullLogSystem());
            this.engine.init(props);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not initialise Velocity");
            iae.initCause(e);
            throw iae;
        }
    }

    public C getExtraConfig() {
        return this.extraConfig;
    }

    public final void generate() throws Exception {
        VelocityContext context = this.createAndPopulateContext();
        try (Writer writer = WriterFactory.newWriter((File)this.config.getOutputFile(), (String)this.config.getEncoding());){
            this.velocityTemplate.merge((Context)context, writer);
            writer.flush();
        }
    }

    protected abstract String getDependenciesText();

    protected VelocityContext createAndPopulateContext() {
        VelocityContext context = new VelocityContext();
        context.put("dependencies", (Object)this.getDependenciesText());
        context.put("arguments", (Object)this.getArgumentsText());
        this.addPropertiesToContext(System.getProperties(), context);
        MavenProject mavenProject = this.config.getMavenProject();
        String encoding = this.config.getEncoding();
        this.addPropertiesToContext(mavenProject.getProperties(), context);
        this.addPropertiesToContext(this.extraConfig.getProperties(), context);
        context.put("project", (Object)mavenProject.getModel());
        context.put("jnlpCodebase", (Object)this.extraConfig.getJnlpCodeBase());
        context.put("informationTitle", (Object)mavenProject.getModel().getName());
        context.put("informationDescription", (Object)mavenProject.getModel().getDescription());
        if (mavenProject.getModel().getOrganization() != null) {
            context.put("informationVendor", (Object)mavenProject.getModel().getOrganization().getName());
            context.put("informationHomepage", (Object)mavenProject.getModel().getOrganization().getUrl());
        }
        Date timestamp = new Date();
        context.put("explicitTimestamp", (Object)this.dateToExplicitTimestamp(timestamp));
        context.put("explicitTimestampUTC", (Object)this.dateToExplicitTimestampUTC(timestamp));
        context.put("outputFile", (Object)this.config.getOutputFile().getName());
        context.put("mainClass", (Object)this.config.getMainClass());
        context.put("encoding", (Object)encoding);
        context.put("input.encoding", (Object)encoding);
        context.put("output.encoding", (Object)encoding);
        context.put("allPermissions", (Object)BooleanUtils.toBoolean((String)this.extraConfig.getAllPermissions()));
        context.put("offlineAllowed", (Object)BooleanUtils.toBoolean((String)this.extraConfig.getOfflineAllowed()));
        context.put("jnlpspec", (Object)this.extraConfig.getJnlpSpec());
        context.put("j2seVersion", (Object)this.extraConfig.getJ2seVersion());
        return context;
    }

    protected abstract String getArgumentsText();

    private void addPropertiesToContext(Map<?, ?> properties, VelocityContext context) {
        if (properties != null) {
            for (Object o : properties.keySet()) {
                String nextKey = (String)o;
                Object nextValue = properties.get(nextKey);
                context.put(nextKey, (Object)nextValue.toString());
            }
        }
    }

    private String dateToExplicitTimestamp(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        return "TS: " + df.format(date);
    }

    private String dateToExplicitTimestampUTC(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return "TS: " + df.format(date) + "Z";
    }

    protected String indentText(int level, String text) {
        StringBuilder buffer = new StringBuilder();
        String[] lines = text.split("\n");
        String prefix = StringUtils.leftPad((String)"", (int)level);
        for (String line : lines) {
            buffer.append(prefix).append(line).append(EOL);
        }
        return buffer.toString();
    }
}

