/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webminifier.closure;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.webminifier.AbstractCompressor;
import org.codehaus.mojo.webminifier.ExceptionState;

public class ClosureJsCompressor
extends AbstractCompressor {
    private CompilationLevel compilationLevel;
    private boolean acceptConstKeyword;

    public ClosureJsCompressor(InputStream source, OutputStream target, String encoding, Log logger) {
        super(source, target, encoding, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress() throws IOException {
        JSError[] warnings;
        JSError[] errors;
        Compiler.setLoggingLevel((Level)Level.OFF);
        Compiler compiler = new Compiler();
        SourceFile sourceFile = SourceFile.builder().withCharset(Charset.forName(this.encoding)).buildFromInputStream("input", this.source);
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        options.setAcceptConstKeyword(this.acceptConstKeyword);
        options.setOutputCharset(this.encoding);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        List externs = Collections.emptyList();
        List<SourceFile> inputs = Arrays.asList(sourceFile);
        Result result = compiler.compile(externs, inputs, options);
        this.exceptionState = new ExceptionState();
        for (JSError error : errors = result.errors) {
            this.logger.error((CharSequence)error.toString());
        }
        if (errors.length > 0) {
            this.exceptionState.signalErrors();
        }
        for (JSError warning : warnings = result.warnings) {
            this.logger.warn((CharSequence)warning.toString());
        }
        if (warnings.length > 0) {
            this.exceptionState.signalWarnings();
        }
        OutputStreamWriter resourceWriter = new OutputStreamWriter(this.target, this.encoding);
        try {
            resourceWriter.append(compiler.toSource());
        }
        finally {
            resourceWriter.close();
        }
    }

    public void setOptions(CompilationLevel compilationLevelParam, boolean acceptConstKeywordParam) {
        this.compilationLevel = compilationLevelParam;
        this.acceptConstKeyword = acceptConstKeywordParam;
    }
}

