/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.wagon.shared.WagonFactory;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.mojo.wagon.shared.WagonUtils;

public abstract class AbstractWagonMojo
extends AbstractMojo {
    @Inject
    protected WagonFactory wagonFactory;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="wagon.skip")
    protected boolean skip = false;

    protected Wagon createWagon(String id, String url) throws MojoExecutionException {
        try {
            return this.wagonFactory.create(url, id, this.settings);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create a Wagon instance for " + url, e);
        }
    }

    protected WagonFileSet getWagonFileSet(String fromDir, String includes, String excludes, boolean caseSensitive, String toDir) {
        return WagonUtils.getWagonFileSet(fromDir, includes, excludes, caseSensitive, toDir);
    }
}

