/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.plexus.util.StringUtils;

public class WagonUtils {
    public static Wagon createWagon(String id, String url, WagonManager wagonManager, Settings settings, Log logger) throws WagonException, UnsupportedProtocolException, WagonConfigurationException {
        ProxyInfo proxyInfo;
        Wagon wagon = null;
        Repository repository = new Repository(id, url);
        repository.setPermissions(WagonUtils.getPermissions(id, settings));
        wagon = wagonManager.getWagon(repository);
        if (logger.isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        if ((proxyInfo = WagonUtils.getProxyInfo(settings)) != null) {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
        } else {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()));
        }
        return wagon;
    }

    public static WagonFileSet getWagonFileSet(String fromDir, String includes, String excludes, boolean isCaseSensitive, String toDir) {
        WagonFileSet fileSet = new WagonFileSet();
        fileSet.setDirectory(fromDir);
        if (!StringUtils.isBlank((String)includes)) {
            fileSet.setIncludes(StringUtils.split((String)includes, (String)","));
        }
        if (!StringUtils.isBlank((String)excludes)) {
            fileSet.setExcludes(StringUtils.split((String)excludes, (String)","));
        }
        fileSet.setCaseSensitive(isCaseSensitive);
        fileSet.setOutputDirectory(toDir);
        return fileSet;
    }

    public static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }

    private static RepositoryPermissions getPermissions(String id, Settings settings) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        Server server = settings.getServer(id);
        if (server == null) {
            return null;
        }
        String filePerms = server.getFilePermissions();
        String dirPerms = server.getDirectoryPermissions();
        if (StringUtils.isBlank((String)filePerms) && StringUtils.isBlank((String)dirPerms)) {
            return null;
        }
        RepositoryPermissions permissions = new RepositoryPermissions();
        permissions.setFileMode(filePerms);
        permissions.setDirectoryMode(dirPerms);
        return permissions;
    }
}

